/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.deploy.client.ComponentAttributesResult;
import com.sap.core.deploy.client.DeployClient;
import com.sap.core.deploy.client.IConfigurationManager;
import com.sap.core.deploy.client.cmd.commands.DeployApplicationCommand;
import com.sap.core.deploy.client.cmd.converters.VmSizeParameterConverter;
import com.sap.core.deploy.client.cmd.timeout.SynchronousProgressMonitor;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.core.deploy.client.cmd.validators.CompressionTypeValidator;
import com.sap.core.deploy.client.cmd.validators.JVMVersionParamValidator;
import com.sap.core.deploy.client.cmd.validators.PermStorageModeParamValidator;
import com.sap.core.deploy.client.cmd.validators.SecureStringForXMLParamValidator;
import com.sap.core.deploy.client.cmd.validators.TomcatConnectorParamsValidator;
import com.sap.core.deploy.commons.rest.entity.PermStorage;
import com.sap.core.deploy.commons.rest.entity.RuntimeArgument;
import com.sap.core.deploy.commons.rest.entity.enumerations.VmSize;
import com.sap.core.deploy.commons.rest.entity.request.ApplicationRequest;
import com.sap.core.deploy.commons.util.ParameterHelper;
import com.sap.core.deploy.commons.util.VmArgumentsUtil;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.help.ordering.Group;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

@Parameters(commandDescription="Sets a new value for an application property. Execute the command once for each property that you want to set.")
public class SetApplicationPropertyCommand
extends DeployApplicationCommand {
    private static List<String> modifiableParametersList = new ArrayList<String>();
    private static Map<String, String> parameterNamesToLabels;
    private static final Logger LOGGER;
    @Group(group="command-specific parameters")
    @Parameter(names={"-m", "-min", "--minimum-processes"}, description="Minimum number of server processes")
    Integer min;
    @Group(group="command-specific parameters")
    @Parameter(names={"-M", "-max", "--maximum-processes"}, description="Maximum number of server processes")
    Integer max;
    @Group(group="command-specific parameters")
    @Parameter(names={"-V", "--vm-arguments"}, description="Java Virtual Machine arguments")
    String vmArguments;
    @Group(group="command-specific parameters")
    @Parameter(names={"-j", "--java-version"}, description="Java Virtual Machine major version number. Use either 6 or 7 (recommended)", validateWith=JVMVersionParamValidator.class)
    String jvmVersion;
    @Group(group="command-specific parameters")
    @Parameter(names={"-z", "--size"}, description="Compute unit size. Acceptable values: lite, pro, prem, prem-plus. Default: the smallest size from the subaccount quotas", converter=VmSizeParameterConverter.class)
    VmSize vmSize;
    @Group(group="command-specific parameters")
    @Parameter(names={"--runtime-version"}, description="Version of SAP Cloud Platform application runtime")
    String runtimeVersion;
    @Group(group="tomcat connector attributes", rank=1)
    @Parameter(names={"--compression"}, description="Enables or disables gzip response compression. Acceptable values: 'on', 'off', 'force' or an integer. Default: 'off'", validateWith=CompressionTypeValidator.class)
    String compression;
    @Group(group="tomcat connector attributes", rank=3)
    @Parameter(names={"--compressible-mime-type"}, description="Comma-separated list of MIME types for which compression will be used. Default: 'text/html, text/xml, text/plain'", validateWith=CompressionTypeValidator.class)
    String compressibleMimeTypes;
    @Group(group="tomcat connector attributes", rank=2)
    @Parameter(names={"--compression-min-size"}, description="Sets compression threshold in bytes. Only responses bigger than this value get compressed. Default: 2048", validateWith=CompressionTypeValidator.class)
    String compressionMinSize;
    @Group(group="tomcat connector attributes", rank=4)
    @Parameter(names={"--uri-encoding"}, description="Specifies the character encoding used to decode the URI bytes. Acceptable values: all encodings supported by JRE version 6 or higher. Default: ISO-8859-1", validateWith=SecureStringForXMLParamValidator.class)
    String uriEncoding;
    @Group(group="tomcat connector attributes", rank=5)
    @Parameter(names={"--max-threads"}, description="Specifies the maximum number of simultaneous requests that can be handled. Default: 200", validateWith=TomcatConnectorParamsValidator.class)
    String maxThreads;
    @Group(group="tomcat connector attributes", rank=6)
    @Parameter(names={"--connection-timeout"}, description="Defines the number of milliseconds to wait for the request URI line to be presented after accepting a connection. Default: 20000", validateWith=TomcatConnectorParamsValidator.class)
    String connectionTimeout;
    @Group(group="command-specific parameters")
    @Parameter(names={"--file-storage-mode"}, description="Experimental! File storage mode. Possible values: persistent, local", hidden=true, validateWith=PermStorageModeParamValidator.class)
    String permStorageMode;
    @Group(group="command-specific parameters")
    @Parameter(names={"--file-storage-size"}, description="Experimental! Size of the file storage in GiBs. Default value is 10 GiBs", hidden=true)
    Integer permStorageSize;
    @Group(group="command-specific parameters")
    @Parameter(names={"--file-storage-local-path"}, description="Experimental! The path where file storage will be mounted to, relative to runtime folder", hidden=true)
    String permStorageLocalPath;
    @Parameter(names={"--ev"}, description="Sets one environment variable; can be used multiple times in one execution.\nExample: --ev key=value --ev \"key2=value2\". Keys cannot contain spaces.")
    Set<String> environmentVariables;
    protected Map<String, Object> parametersToUpdate = new HashMap<String, Object>();
    private Map<String, String> metadata;

    @Override
    public void run() throws CommandException {
        this.dumpParameters();
        this.metadata = CheckHelper.validateAndConvertEnvironmentVariablesToMetadataMap(this.environmentVariables);
        CheckHelper.dumpWarningMessageIfNeeded(this.metadata);
        if (CheckHelper.checkArgsListComponents(this.account, this.application, this.host)) {
            this.populateParametersForUpdate();
            this.askForPasswordAndInitHttpClient();
            IConfigurationManager cfgManager = this.getConfigurationManager();
            SynchronousProgressMonitor monitor = new SynchronousProgressMonitor("Requesting setting of an application property...");
            this.preprocessInputParameters();
            try {
                monitor.startMonitor();
                ComponentAttributesResult result = cfgManager.setConfigurationProperty(this.application, this.host, this.buildApplicationRequest(this.application));
                this.dumpResult(result);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
                throw new CommandException(e.getMessage(), 166);
            }
            finally {
                monitor.stopMonitor();
            }
        } else {
            throw new HelpException("(!)ERROR: Invalid parameters", 10);
        }
    }

    @Override
    public String getName() {
        return "set-application-property";
    }

    protected IConfigurationManager getConfigurationManager() {
        return DeployClient.getConfigurationManager(this.httpClient, this.account, "CMD Tools", null);
    }

    protected void preprocessInputParameters() {
        this.preprocessVmArguments();
    }

    private void preprocessVmArguments() {
        if (this.vmArguments == null) {
            return;
        }
        List<String> extractedVmArgs = ParameterHelper.extractArguments(this.vmArguments);
        VmArgumentsUtil vmArgumentsUtil = new VmArgumentsUtil();
        this.vmArguments = vmArgumentsUtil.processVmArguments(extractedVmArgs);
    }

    protected void populateParametersForUpdate() {
        try {
            boolean oneFieldHasValue = false;
            String nameForResult = "";
            for (Field field : this.getClass().getDeclaredFields()) {
                Object value;
                if (!this.isModifiable(field.getName()) || null == (value = field.get(this))) continue;
                if (this.isMoreThanOneFiledSet(oneFieldHasValue)) {
                    throw new HelpException("(!)ERROR: Too many properties. Specify one property only.\nIf you need to set several properties, execute the command once for each property.", 10);
                }
                nameForResult = this.getParameterName(field);
                this.parametersToUpdate.put(nameForResult, value);
                oneFieldHasValue = true;
            }
            if (this.parametersToUpdate.isEmpty()) {
                throw new HelpException("(!)ERROR: No property set. Specify a property that you want to set.", 10);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error(e.getMessage(), e);
            throw new HelpException("(!)ERROR: Error while getting parameters", 10);
        }
    }

    private boolean isMoreThanOneFiledSet(boolean oneFieldHasValue) {
        return oneFieldHasValue;
    }

    protected String getParameterName(Field field) {
        String name = null;
        Parameter fieldAnnotation = field.getAnnotation(Parameter.class);
        if (null != fieldAnnotation) {
            String[] names = fieldAnnotation.names();
            if (names == null) {
                name = field.getName();
            } else {
                name = names[names.length - 1];
                if (parameterNamesToLabels.get(name) != null) {
                    return parameterNamesToLabels.get(name);
                }
                while (name.startsWith("-")) {
                    name = name.substring(1);
                }
            }
        }
        return name;
    }

    protected boolean isModifiable(String fieldName) {
        return Collections.binarySearch(modifiableParametersList, fieldName) >= 0;
    }

    private void dumpResult(ComponentAttributesResult result) {
        StringBuilder resultStringBilder;
        if (result.getCode() == 0) {
            resultStringBilder = new StringBuilder("\n");
            if (this.parametersToUpdate.size() == 1) {
                resultStringBilder.append("\nNew property value set:\n");
                String key = (String)this.parametersToUpdate.keySet().toArray()[0];
                String keyPrefix = "\t" + key + " : ";
                String whiteSpacesPrefix = keyPrefix.replaceAll("\\S", " ");
                resultStringBilder.append(keyPrefix);
                resultStringBilder.append(this.convertParameterValueToString(this.parametersToUpdate.get(key), whiteSpacesPrefix));
                resultStringBilder.append("\n\n");
            }
        } else {
            System.out.println();
            DeployDumpHelper.dumpWithDateNewLine("Request for setting an application property finished with an error.");
            throw new CommandException(result.getMessage(), 106);
        }
        this.addWarnings(resultStringBilder, result);
        resultStringBilder.append("For the changes to take effect, restart the application.\n");
        System.out.println(resultStringBilder.toString());
    }

    private String convertParameterValueToString(Object value, String whiteSpacesPrefix) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return this.convertParameterListValueToString((List)value, whiteSpacesPrefix);
        }
        return value.toString();
    }

    private String convertParameterListValueToString(List<Object> list, String whiteSpacesPrefix) {
        StringBuilder sb = new StringBuilder();
        int lastElemIndex = list.size() - 1;
        for (int i = 0; i < lastElemIndex; ++i) {
            sb.append(list.get(i));
            sb.append("\n");
            sb.append(whiteSpacesPrefix);
        }
        sb.append(list.get(lastElemIndex));
        return sb.toString();
    }

    private void addWarnings(StringBuilder resultStringBilder, ComponentAttributesResult result) {
        String warnings = result.getMessage();
        if (warnings != null && !warnings.trim().isEmpty()) {
            resultStringBilder.append("\n" + warnings + "\n");
        }
    }

    private ApplicationRequest buildApplicationRequest(String applicationName) {
        ApplicationRequest applicationRequest = new ApplicationRequest();
        applicationRequest.setApplicationName(applicationName);
        if (this.vmSize != null) {
            applicationRequest.setComputeUnitSize(this.vmSize.name());
        }
        applicationRequest.setMinProcesses(this.min);
        applicationRequest.setMaxProcesses(this.max);
        applicationRequest.setRuntimeVersion(this.runtimeVersion);
        ArrayList<RuntimeArgument> runtimeArguments = new ArrayList<RuntimeArgument>();
        runtimeArguments.add(new RuntimeArgument("compressibleMimeTypes", this.compressibleMimeTypes));
        runtimeArguments.add(new RuntimeArgument("compression", this.compression));
        runtimeArguments.add(new RuntimeArgument("compressionMinSize", this.compressionMinSize));
        runtimeArguments.add(new RuntimeArgument("jvmVersion", this.jvmVersion));
        runtimeArguments.add(new RuntimeArgument("uriEncoding", this.uriEncoding));
        runtimeArguments.add(new RuntimeArgument("maxThreads", this.maxThreads));
        runtimeArguments.add(new RuntimeArgument("connectionTimeout", this.connectionTimeout));
        runtimeArguments.add(new RuntimeArgument("vmArguments", this.vmArguments));
        applicationRequest.setRuntimeArguments(runtimeArguments);
        PermStorage permStorage = new PermStorage();
        permStorage.setLocalPath(this.permStorageLocalPath);
        permStorage.setMode(this.permStorageMode);
        if (this.permStorageSize != null) {
            permStorage.setSize("" + this.permStorageSize);
        }
        applicationRequest.setPermStorage(permStorage);
        if (this.environmentVariables != null && !this.environmentVariables.isEmpty()) {
            applicationRequest.setMetadata(this.metadata);
        }
        return applicationRequest;
    }

    private void dumpParameters() {
        ArrayList<Object> argsList = new ArrayList<Object>();
        Collections.addAll(argsList, "application", this.application, "subaccount", this.account);
        if (this.vmSize != null) {
            Collections.addAll(argsList, "compute unit size", this.vmSize.optionName());
        }
        if (this.permStorageMode != null && !this.permStorageMode.equals("none")) {
            Collections.addAll(argsList, "file storage mode", this.permStorageMode, "file storage size (GB)", this.permStorageSize, "file storage path", this.permStorageLocalPath);
        }
        Collections.addAll(argsList, "runtime version", this.runtimeVersion, "vm arguments", this.vmArguments, "JVM version", this.jvmVersion, "host", this.host, "compression", this.compression, "compressible-mime-type", this.compressibleMimeTypes, "compression-min-size", this.compressionMinSize, "URI encoding", this.uriEncoding, "max-threads", this.maxThreads, "connection-timeout", this.connectionTimeout);
        if (null != this.min && null != this.max) {
            Collections.addAll(argsList, "elasticity data", "[" + this.min + " .. " + this.max + "]");
        }
        DeployDumpHelper.addEnvVariablesToArgsList(argsList, this.environmentVariables);
        DumpHelper.dumpOperationList(this.user, "Requesting set application property for:", argsList.toArray());
    }

    static {
        modifiableParametersList.add("min");
        modifiableParametersList.add("max");
        modifiableParametersList.add("vmArguments");
        modifiableParametersList.add("jvmVersion");
        modifiableParametersList.add("vmSize");
        modifiableParametersList.add("runtimeVersion");
        modifiableParametersList.add("compression");
        modifiableParametersList.add("compressibleMimeTypes");
        modifiableParametersList.add("compressionMinSize");
        modifiableParametersList.add("uriEncoding");
        modifiableParametersList.add("maxThreads");
        modifiableParametersList.add("connectionTimeout");
        modifiableParametersList.add("permStorageMode");
        modifiableParametersList.add("permStorageSize");
        modifiableParametersList.add("permStorageLocalPath");
        modifiableParametersList.add("environmentVariables");
        Collections.sort(modifiableParametersList);
        parameterNamesToLabels = new HashMap<String, String>();
        parameterNamesToLabels.put("--ev", "environment variables");
        LOGGER = Logger.getLogger(SetApplicationPropertyCommand.class);
    }
}

