/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.sap.core.deploy.client.DeployClient;
import com.sap.core.deploy.client.DeployResult;
import com.sap.core.deploy.client.IComponentUrlManager;
import com.sap.core.deploy.client.cmd.commands.DeployApplicationCommand;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;
import java.util.ArrayList;
import java.util.Collections;

public class SetUrlCommand
extends DeployApplicationCommand {
    @Parameter(names={"-c", "-component", "--component"}, description="Component", validateWith=SACValidator.class, hidden=true)
    String component = "web";
    @Parameter(names={"-x", "-url", "--url-prefix"}, description="URL prefix of the component")
    String shortUrl;

    @Override
    public void run() throws CommandException {
        DeployResult deployResult;
        if (CheckHelper.checkArgsSetUrl(this.account, this.application, this.component, this.host, this.shortUrl)) {
            this.dumpParameters();
            super.askForPasswordAndInitHttpClient();
            IComponentUrlManager componentUrlManager = DeployClient.getComponentUrlManager(this.httpClient);
            deployResult = null;
            try {
                deployResult = componentUrlManager.setComponentUrl(this.account, this.application, this.component, this.shortUrl, this.host);
            }
            catch (Exception e) {
                throw new CommandException("Setting component URL failed", e, 119);
            }
        } else {
            throw new HelpException("Invalid parameters", 120);
        }
        DeployDumpHelper.printAndCheckDeployResult("Setting of URL", deployResult, 134, false);
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        if (!this.component.equalsIgnoreCase("web")) {
            Collections.addAll(argsList, "component", this.component);
        }
        Collections.addAll(argsList, "application", this.application, "subaccount", this.account, "component URL", this.shortUrl, "host", this.host);
        DumpHelper.dumpOperationList(this.user, "Requesting set of URL for:", argsList.toArray());
    }

    @Override
    public String getName() {
        return "set-url-prefix";
    }
}

