/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.deploy.client.cmd.commands.DeployApplicationCommand;
import com.sap.core.deploy.client.cmd.helpers.ListEntityHelper;
import com.sap.core.deploy.client.cmd.helpers.StartStopHelper;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.Set;

@Parameters(commandDescription="Starts an application")
public class StartCommand
extends DeployApplicationCommand {
    @Parameter(names={"-c", "-component", "--component"}, description="Component", hidden=true)
    String component = "web";
    @Parameter(names={"-t", "-tenant", "--tenant"}, description="Tenant-isolated application process for the given tenant", hidden=true)
    String tenant;
    @Parameter(names={"-y", "-sync", "--synchronous"}, description="Wait for the operation to complete")
    boolean synchronous;
    @Parameter(names={"-k", "--status-check"}, description="Operation will fail if the component is not deployed or already in the desired state", hidden=true)
    boolean statusCheck;
    @Parameter(names={"--ignore-failure"}, description="Failed operation will not cause the command to exit with error", hidden=true)
    boolean ignoreFailure;
    @Parameter(names={"--regular-expression"}, description="Treat the application name as regular expression pattern", hidden=true)
    boolean regExp;
    @Parameter(names={"--disabled"}, description="Starts an application process in disabled state, so that it is not available for new connections")
    boolean startDisabled;

    @Override
    public void run() throws CommandException {
        CheckHelper.validateApplicationAndComponentArguments(this.regExp, this.application, this.component);
        StartStopHelper startStopHelper = new StartStopHelper(this.account, this);
        if (this.regExp) {
            startStopHelper.dumpParameters("mass start", null, this.application, this.component, this.tenant, this.synchronous, this.startDisabled);
            ListEntityHelper listEntityHelper = new ListEntityHelper(this.account, this);
            Set<String> matchingApplications = listEntityHelper.getApplications(this.application);
            for (String applicationName : matchingApplications) {
                if (this.component.equals("web")) {
                    startStopHelper.start(applicationName, this.component, this.tenant, this.synchronous, this.statusCheck, this.ignoreFailure, this.startDisabled);
                    continue;
                }
                Set<String> matchingComponents = listEntityHelper.getComponents(applicationName, this.component);
                for (String matchingComponent : matchingComponents) {
                    startStopHelper.start(applicationName, matchingComponent, this.tenant, this.synchronous, this.statusCheck, this.ignoreFailure, this.startDisabled);
                }
            }
        } else {
            startStopHelper.start(this.application, this.component, this.tenant, this.synchronous, this.statusCheck, this.ignoreFailure, this.startDisabled);
        }
    }

    @Override
    public String getName() {
        return "start";
    }

    @Override
    protected void checkApplicationParameterValue() {
        if (!this.regExp) {
            super.checkApplicationParameterValue();
        }
    }
}

