/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.deploy.client.cmd.commands.DeployProcessIdCommand;
import com.sap.core.deploy.client.cmd.helpers.ListEntityHelper;
import com.sap.core.deploy.client.cmd.helpers.StartStopHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import java.util.Set;

@Parameters(commandDescription="Stops an application")
public class StopCommand
extends DeployProcessIdCommand {
    @Parameter(names={"-c", "-component", "--component"}, description="Component", hidden=true)
    String component = "web";
    @Parameter(names={"-t", "-tenant", "--tenant"}, description="Tenant-isolated application process for the given tenant", hidden=true)
    String tenant;
    @Parameter(names={"-y", "-sync", "--synchronous"}, description="Wait for the operation to complete")
    boolean synchronous;
    @Parameter(names={"-k", "--status-check"}, description="Operation will fail if the component is not deployed or already in the desired state", hidden=true)
    boolean statusCheck;
    @Parameter(names={"--ignore-failure"}, description="Failed operation will not cause the command to exit with error", hidden=true)
    boolean ignoreFailure;
    @Parameter(names={"--regular-expression"}, description="Treat the application name as regular expression pattern", hidden=true)
    boolean regExp;

    @Override
    public void run() throws CommandException {
        StartStopHelper startStopHelper = new StartStopHelper(this.account, this);
        if (!this.regExp) {
            if (this.applicationProcessId != null) {
                startStopHelper.stop(this.applicationProcessId, this.synchronous, this.statusCheck, this.ignoreFailure);
            } else {
                startStopHelper.stop(this.application, this.component, this.tenant, this.synchronous, this.statusCheck, this.ignoreFailure);
            }
        } else {
            if (this.applicationProcessId != null) {
                throw new HelpException("Cannot use regular expression and application process ID at the same time");
            }
            startStopHelper.dumpParameters("mass stop", null, this.application, this.component, this.tenant, this.synchronous);
            ListEntityHelper listEntityHelper = new ListEntityHelper(this.account, this);
            Set<String> matchingApplications = listEntityHelper.getApplications(this.application);
            for (String applicationName : matchingApplications) {
                if (this.component.equals("web")) {
                    startStopHelper.stop(applicationName, this.component, this.tenant, this.synchronous, this.statusCheck, this.ignoreFailure);
                    continue;
                }
                Set<String> matchingComponents = listEntityHelper.getComponents(applicationName, this.component);
                for (String matchingComponent : matchingComponents) {
                    startStopHelper.stop(applicationName, matchingComponent, this.tenant, this.synchronous, this.statusCheck, this.ignoreFailure);
                }
            }
        }
    }

    @Override
    public String getName() {
        return "stop";
    }

    @Override
    protected void checkApplicationParameterValue() {
        if (!this.regExp) {
            super.checkApplicationParameterValue();
        }
    }
}

