/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.deploy.client.cmd.commands.DeployApplicationCommand;
import com.sap.core.deploy.client.cmd.helpers.ListEntityHelper;
import com.sap.core.deploy.client.cmd.helpers.UndeployHelper;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import java.util.Set;

@Parameters(commandDescription="Undeploys an application")
public class UndeployCommand
extends DeployApplicationCommand {
    @Parameter(names={"-c", "-component", "--component"}, description="Component", hidden=true)
    String component;
    @Parameter(names={"--ignore-failure"}, description="Failed operation will not cause the command to exit with error", hidden=true)
    boolean ignoreFailure;
    @Parameter(names={"--regular-expression"}, description="Treat the application name as regular expression pattern", hidden=true)
    boolean regExp;

    @Override
    public void run() throws CommandException {
        this.validateArguments();
        UndeployHelper undeployHelper = new UndeployHelper(this.account, this);
        if (this.regExp) {
            undeployHelper.dumpParameters("mass undeploy", this.application, this.component);
            ListEntityHelper listEntityHelper = new ListEntityHelper(this.account, this);
            Set<String> matchingApplications = listEntityHelper.getApplications(this.application);
            for (String applicationName : matchingApplications) {
                if (this.component == null || this.component.equals("web")) {
                    undeployHelper.undeploy(applicationName, this.component, this.ignoreFailure);
                    continue;
                }
                Set<String> matchingComponents = listEntityHelper.getComponents(applicationName, this.component);
                for (String matchingComponent : matchingComponents) {
                    undeployHelper.undeploy(applicationName, matchingComponent, this.ignoreFailure);
                }
            }
        } else {
            undeployHelper.undeploy(this.application, this.component, this.ignoreFailure);
        }
    }

    private void validateArguments() {
        if (!CheckHelper.checkArgsSpecifiedAccountApplicationHost(this.account, this.application, this.host)) {
            throw new HelpException("Invalid parameters", 128);
        }
    }

    @Override
    public String getName() {
        return "undeploy";
    }

    @Override
    protected void checkApplicationParameterValue() {
        if (!this.regExp) {
            super.checkApplicationParameterValue();
        }
    }
}

