/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.helpers;

import com.sap.core.deploy.client.DeployFeedbackListener;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import java.util.HashSet;
import java.util.Set;

public class ConsoleDeployFeedbackListener
implements DeployFeedbackListener {
    private static final long PRINT_PERCENT_INTERVAL = 5000L;
    private static final long PRINT_PERCENT_TIMEOUT = 60000L;
    int lastPercentPrinted = 0;
    long lastTimePercentPrinted = 0L;
    Set<String> progressingSuboperationNames = new HashSet<String>();

    @Override
    public void deployStarted(int suboperationsCount) {
    }

    @Override
    public void suboperationStarted(String suboperationName, String detailMessage) {
        DeployDumpHelper.dumpWithDate(detailMessage);
        this.lastTimePercentPrinted = System.currentTimeMillis();
    }

    @Override
    public void suboperationProgressed(String suboperationName, String detailMessage, int percentCompleted) {
        this.progressingSuboperationNames.add(suboperationName);
        if (percentCompleted > this.lastPercentPrinted && percentCompleted < 100) {
            if (System.currentTimeMillis() - this.lastTimePercentPrinted > 60000L) {
                this.printPercent(percentCompleted);
            } else {
                int roundByTenPercents = percentCompleted / 10 * 10;
                if (roundByTenPercents > this.lastPercentPrinted && System.currentTimeMillis() - this.lastTimePercentPrinted > 5000L) {
                    this.printPercent(roundByTenPercents);
                }
            }
        }
    }

    private void printPercent(int percentToPrint) {
        this.lastTimePercentPrinted = System.currentTimeMillis();
        this.lastPercentPrinted = percentToPrint;
        this.print("." + percentToPrint + "%");
    }

    protected void print(String message) {
        System.out.print(message);
    }

    @Override
    public void suboperationCompleted(String suboperationName, String detailMessage) {
        if (this.progressingSuboperationNames.remove(suboperationName)) {
            this.printPercent(100);
        }
        DeployDumpHelper.dumpWithDate(detailMessage);
    }

    @Override
    public void deployFinished(boolean success, String detailMessage) {
    }
}

