/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.helpers;

import com.sap.core.deploy.client.DeployResult;
import com.sap.core.deploy.client.TimeAndSizeUtils;
import com.sap.core.deploy.client.cmd.commands.DeployConsoleCommand;
import com.sap.core.deploy.client.cmd.helpers.Helper;
import com.sap.core.deploy.client.cmd.timeout.SynchronousProgressMonitor;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.core.deploy.client.cmd.util.DescriptorHelper;
import com.sap.core.deploy.client.cmd.util.ExternalProcessExecutor;
import com.sap.core.deploy.client.cmd.util.RuntimeVersionsHelper;
import com.sap.core.deploy.client.utils.DeployClientUtils;
import com.sap.core.deploy.client.utils.DeployTimeoutUtil;
import com.sap.core.deploy.commons.PropertiesConstants;
import com.sap.core.deploy.commons.rest.entity.enumerations.VmSize;
import com.sap.core.deploy.commons.runtime.Version;
import com.sap.core.deploy.commons.util.DeploymentUtils;
import com.sap.core.deploy.commons.util.ParameterHelper;
import com.sap.core.jpaasrepository.api.Descriptor;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.version.VersionUtilities;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;

public class DeployHelper
extends Helper {
    public static final String CONNECTION_RESET_ADDITIONAL_MESSAGE = "%s failed. Possible cause: network or configuration issue that leads to inactive communication. By default, idle connection is reset after certain time.";
    private static final String OLD_VERSION = "Warning: The application runtime version (%s) is lower than version (%s) of the SDK. The application may not work correctly if it uses features not available in version %s";
    private static final String INCOMPATIBLE_VERSION = "Warning: The application runtime version (%s) is not compatible with version (%s) of the SDK. The application may not work correctly if it uses features not available in version %s";
    private static final File JAVA_ENV_TEMP_DIR = new File(System.getProperty("java.io.tmpdir"));

    public DeployHelper(String account, DeployConsoleCommand command) {
        super(account, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deploy(String application, String component, String source, String installableUnits, String iuVersion, int min, int max, String shortUrl, String appDomains, String services, boolean mirror, String severity, String configFolder, String vmArguments, String jvmVersion, String serviceInstancesCfg, VmSize vmSize, String runtimeId, String runtimeVersion, String uploadConnections, String compression, String compressibleMimeTypes, String compressionMinSize, String permStorageMode, int permStorageSize, String permStorageLocalPath, String uriEncoding, String maxThreads, String connectionTimeout, long deployTimeout, boolean delta, Map<String, String> metadataMap) {
        File localUpdateSite;
        boolean warsAndBundlesDetected;
        String[] deploymentLocations = DeployClientUtils.splitStringWithTrim(source, ",");
        DeployTimeoutUtil.setDeployTimeout(deployTimeout);
        HashMap<String, String> ignoredFilesAndReason = new HashMap<String, String>();
        try {
            warsAndBundlesDetected = DeployClientUtils.detectLocalWarFilesAndBundles(deploymentLocations, ignoredFilesAndReason).length > 0;
            localUpdateSite = DeployClientUtils.detectLocalUpdateSiteIfAvailable(deploymentLocations);
        }
        catch (IOException ioe) {
            throw new CommandException("I/O error occurred while verifying the provided source locations for deployment", ioe, 105);
        }
        catch (IllegalArgumentException e) {
            throw new CommandException("Invalid value of parameter --source", e, 106);
        }
        if (!this.checkArgsDeploy(this.account, application, component, source, this.host, installableUnits, iuVersion, warsAndBundlesDetected)) throw new HelpException("Invalid parameters", 109);
        this.checkArgsPermanentStorage(permStorageMode, permStorageSize, permStorageLocalPath);
        if ("EMPTY_SITE".equals(source)) {
            mirror = false;
        }
        File tempDirectory = null;
        try {
            String[] splitServices;
            String repo;
            if (mirror && localUpdateSite == null && !warsAndBundlesDetected) {
                try {
                    tempDirectory = DeploymentUtils.createTempDirectory(JAVA_ENV_TEMP_DIR);
                    for (String singleRepo : deploymentLocations) {
                        String sourceRepo = singleRepo.trim();
                        this.mirrorP2Repo(sourceRepo, tempDirectory);
                    }
                    repo = tempDirectory.getCanonicalPath();
                }
                catch (Exception e) {
                    throw new CommandException("Failed to download the update site(s) to the local file system", e, 107);
                }
            } else {
                repo = source;
                if (!(localUpdateSite != null && installableUnits != null || ignoredFilesAndReason.isEmpty())) {
                    this.printIgnoredFiles(ignoredFilesAndReason);
                }
            }
            String[] stringArray = splitServices = services == null ? null : DeployClientUtils.splitStringWithTrim(services, ",");
            if (splitServices == null || splitServices.length == 0) {
                splitServices = PropertiesConstants.ALL_SERVICES;
            }
            List<String> extractedArguments = ParameterHelper.extractArguments(vmArguments);
            Descriptor jpaasRepoDescriptor = DescriptorHelper.createDescriptor(repo, installableUnits, iuVersion, shortUrl, splitServices, severity, min, max, extractedArguments, serviceInstancesCfg, jvmVersion, vmSize, uploadConnections, compression, compressibleMimeTypes, compressionMinSize, permStorageMode, permStorageSize, permStorageLocalPath, uriEncoding, maxThreads, connectionTimeout, delta, metadataMap);
            String[] splitAppDomains = appDomains == null ? null : DeployClientUtils.splitStringWithTrim(appDomains, ",");
            DescriptorHelper.setAppDomains(splitAppDomains, jpaasRepoDescriptor);
            DescriptorHelper.setAppRuntimeId(runtimeId, jpaasRepoDescriptor);
            DescriptorHelper.setAppRuntimeVersion(runtimeVersion, jpaasRepoDescriptor);
            if (CheckHelper.checkFolder(configFolder)) {
                jpaasRepoDescriptor.set("configuration_folder", configFolder);
            }
            this.sanityRuntimeVersionCheck(runtimeId, runtimeVersion);
            if (delta) {
                this.deployOperation(application, component, runtimeVersion, jpaasRepoDescriptor, "Delta deployment");
            } else {
                this.deployOperation(application, component, runtimeVersion, jpaasRepoDescriptor, "Deployment");
            }
            if (tempDirectory == null) return;
        }
        catch (Throwable throwable) {
            if (tempDirectory == null) throw throwable;
            DeploymentUtils.deleteDirectory(tempDirectory);
            throw throwable;
        }
        DeploymentUtils.deleteDirectory(tempDirectory);
    }

    protected void printIgnoredFiles(Map<String, String> ignoredFilesAndReason) {
        System.out.println("WARNING: The following files were not recognized as valid artifacts and will be ignored:");
        for (String filePath : ignoredFilesAndReason.keySet()) {
            String reason = ignoredFilesAndReason.get(filePath);
            System.out.println(filePath + " - " + reason);
        }
        System.out.println("Files with extensions other than .war and .jar are ignored by default.");
    }

    protected void deployOperation(String application, String component, String runtimeVersion, Descriptor jpaasRepoDescriptor, String operation) {
        DeployResult deployResult;
        long startTime = System.currentTimeMillis();
        this.initializeDeployClient();
        SynchronousProgressMonitor monitor = new SynchronousProgressMonitor(operation + " started...");
        try {
            DeployDumpHelper.LOGGER.info(operation + " started for [" + this.account + "/" + application + "/" + component + "] with descriptor [" + jpaasRepoDescriptor.toString() + "]");
            monitor.startMonitor();
            deployResult = this.deployer.deploy(application, component, "0.0.0", jpaasRepoDescriptor, this.host);
        }
        catch (Exception e) {
            String errorMessage = "";
            if (e instanceof SocketException && e.getMessage().contains("Connection reset")) {
                errorMessage = String.format(CONNECTION_RESET_ADDITIONAL_MESSAGE, operation);
            } else {
                this.handleThrotllingMode(e, operation);
            }
            throw new CommandException(errorMessage, e, 108);
        }
        finally {
            monitor.stopMonitor();
        }
        this.dumpRuntimeVersionWarning(runtimeVersion);
        DeployDumpHelper.printAndCheckDeployResult(operation, deployResult, 132, false, false);
        DeployDumpHelper.dumpWithDateNewLine("Total time: " + TimeAndSizeUtils.getTimeString(System.currentTimeMillis() - startTime) + "\n");
        DeployDumpHelper.LOGGER.info(operation + " completed successfully");
    }

    private void dumpRuntimeVersionWarning(String runtimeVersion) {
        System.out.println();
        String sdkVersionAsString = VersionUtilities.getRuntimeVersion();
        if (runtimeVersion != null && !sdkVersionAsString.equals("unknown")) {
            int minorVersion;
            Version sdkVersion = new Version(sdkVersionAsString, "");
            String[] runtimeVersionDigits = runtimeVersion.split("\\.");
            if (sdkVersion.getMajor() != Integer.parseInt(runtimeVersionDigits[0])) {
                System.out.println(String.format(INCOMPATIBLE_VERSION, runtimeVersion, sdkVersion.getMajorMinorVersionString(), runtimeVersion));
                return;
            }
            if (runtimeVersionDigits.length >= 2 && (minorVersion = Integer.parseInt(runtimeVersionDigits[1])) < sdkVersion.getMinor()) {
                String majorMinorRuntimeVersionStr = runtimeVersionDigits[0] + "." + runtimeVersionDigits[1];
                System.out.println(String.format(OLD_VERSION, majorMinorRuntimeVersionStr, sdkVersion.getMajorMinorVersionString(), majorMinorRuntimeVersionStr));
            }
        }
    }

    private void sanityRuntimeVersionCheck(String runtimeId, String runtimeVersion) throws CommandException {
        if (runtimeVersion == null) {
            return;
        }
        try {
            new Version(runtimeVersion, "");
        }
        catch (IllegalArgumentException e) {
            RuntimeVersionsHelper helper = new RuntimeVersionsHelper(this.command.getHttpClient(), this.host, runtimeId, false, null);
            Collection<Version> versions = null;
            if (helper.isTheRequestForTheCurrentRuntime()) {
                String sdkVersionAsString = VersionUtilities.getRuntimeVersion();
                if (!sdkVersionAsString.equals("unknown")) {
                    Version sdkVersion = new Version(sdkVersionAsString, "");
                    versions = helper.getVersionsForMajorVersion(runtimeId, sdkVersion.getMajor());
                } else {
                    versions = helper.getAllVersionsForRuntimeId(runtimeId);
                }
            } else {
                versions = helper.getAllVersionsForRuntimeId(runtimeId);
            }
            HashSet<String> majorMinorVersions = new HashSet<String>();
            for (Version version : versions) {
                majorMinorVersions.add(version.getMajorMinorVersionString());
            }
            StringBuilder errorMsg = new StringBuilder("Runtime version '" + runtimeVersion + "' is not valid. List of available runtime versions:\n");
            errorMsg.append("[");
            Iterator iterator = majorMinorVersions.iterator();
            while (iterator.hasNext()) {
                errorMsg.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                errorMsg.append(", ");
            }
            errorMsg.append("]");
            throw new CommandException(errorMsg.toString(), 109);
        }
    }

    protected boolean checkArgsDeploy(String account, String application, String component, String source, String host, String installableUnits, String iuVersion, boolean warsAndBundlesDetected) {
        boolean commonArguments = CheckHelper.checkArgsSpecifiedAccountApplicationComponentHost(account, application, component, host);
        if ("EMPTY_SITE".equals(source) || warsAndBundlesDetected) {
            return commonArguments;
        }
        return commonArguments & CheckHelper.checkArgSpecified("-s", "--source", source) & CheckHelper.checkArgSpecified("-i", "--installable-unit", installableUnits) & CheckHelper.checkArgSpecified("-v", "--installable-unit-version", iuVersion);
    }

    private void checkArgsPermanentStorage(String permStorageMode, int permStorageSize, String permStorageLocalPath) throws CommandException {
        if (!permStorageMode.equals("none")) {
            if (!permStorageMode.equals("persistent") && !permStorageMode.equals("local")) {
                throw new CommandException("Invalid permanent storage mode: " + permStorageMode);
            }
            if (permStorageSize <= 0) {
                throw new CommandException("Permanent storage size can not be less than or equal to 0");
            }
            if (permStorageLocalPath.equals("")) {
                throw new CommandException("Permanent storage local path can not be empty");
            }
        }
    }

    private void mirrorP2Repo(String sourceRepo, File outputDir) throws CommandException {
        int exitCode;
        ExternalProcessExecutor executor = new ExternalProcessExecutor(20, null, null);
        CommandLine mirrorArtifactRepoCmd = this.prepareMirrorRepoCmdString("org.eclipse.equinox.p2.artifact.repository.mirrorApplication", outputDir, sourceRepo);
        System.out.println(DeployDumpHelper.LINE_SEPARATOR + "Mirroring p2 artifact repository: " + mirrorArtifactRepoCmd.toString() + DeployDumpHelper.LINE_SEPARATOR);
        try {
            exitCode = executor.execute(mirrorArtifactRepoCmd);
        }
        catch (IOException ioe) {
            throw new CommandException("Failed to mirror p2 artifact repository from [" + sourceRepo + "] to [" + outputDir + "]", ioe);
        }
        if (executor.isFailure(exitCode)) {
            throw new CommandException("Mirroring of p2 artifact repository failed with exit code [" + exitCode + "]");
        }
        CommandLine mirrorMetadataRepoCmd = this.prepareMirrorRepoCmdString("org.eclipse.equinox.p2.metadata.repository.mirrorApplication", outputDir, sourceRepo);
        System.out.println(DeployDumpHelper.LINE_SEPARATOR + "Mirroring p2 metadata repository: " + mirrorMetadataRepoCmd.toString() + DeployDumpHelper.LINE_SEPARATOR);
        try {
            exitCode = executor.execute(mirrorMetadataRepoCmd);
        }
        catch (IOException ioe) {
            throw new CommandException("Failed to mirror p2 metadata repository from [" + sourceRepo + "] to [" + outputDir + "]", ioe);
        }
        if (executor.isFailure(exitCode)) {
            throw new CommandException("Mirroring of p2 metadata repository failed with exit code [" + exitCode + "]");
        }
        System.out.println(DeployDumpHelper.LINE_SEPARATOR + "Successfully mirrored p2 repository: " + sourceRepo + DeployDumpHelper.LINE_SEPARATOR);
    }

    private CommandLine prepareMirrorRepoCmdString(String artifactOrMetadataMirrorAppId, File mirrorOutput, String sourceRepo) throws CommandException {
        CommandLine cmdLine = new CommandLine(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        String httpProxyHost = System.getProperty("http.proxyHost");
        String httpProxyPort = System.getProperty("http.proxyPort");
        String httpsProxyHost = System.getProperty("https.proxyHost");
        String httpsProxyPort = System.getProperty("https.proxyPort");
        String httpNonProxyHosts = System.getProperty("http.nonProxyHosts");
        String httpsNonProxyHosts = System.getProperty("https.nonProxyHosts");
        if (httpProxyHost != null) {
            cmdLine.addArguments("-Dhttp.proxyHost='" + httpProxyHost + "'", false);
        }
        if (httpProxyPort != null) {
            cmdLine.addArguments("-Dhttp.proxyPort='" + httpProxyPort + "'", false);
        }
        if (httpsProxyHost != null) {
            cmdLine.addArguments("-Dhttps.proxyHost='" + httpsProxyHost + "'", false);
        }
        if (httpsProxyPort != null) {
            cmdLine.addArguments("-Dhttps.proxyPort='" + httpsProxyPort + "'", false);
        }
        if (httpNonProxyHosts != null) {
            cmdLine.addArguments("-Dhttp.nonProxyHosts='" + httpNonProxyHosts + "'", false);
        }
        if (httpsNonProxyHosts != null) {
            cmdLine.addArguments("-Dhttps.nonProxyHosts='" + httpsNonProxyHosts + "'", false);
        }
        try {
            sourceRepo = URLDecoder.decode(sourceRepo, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CommandException("URL [" + sourceRepo + "] cannot be decoded", e, 111);
        }
        File p2MirrorDir = new File(System.getProperty("neo.base.location", "."), "lib/p2utils/plugins");
        String[] files = p2MirrorDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("org.eclipse.equinox.launcher");
            }
        });
        if (files == null || files.length != 1) {
            throw new CommandException("Cannot determine Equinox launcher in [" + p2MirrorDir.getAbsolutePath() + "].", 112);
        }
        cmdLine.addArgument("-jar");
        cmdLine.addArgument(new File(p2MirrorDir, files[0]).getAbsolutePath(), false);
        cmdLine.addArgument("-application");
        cmdLine.addArgument(artifactOrMetadataMirrorAppId);
        cmdLine.addArgument("-source");
        cmdLine.addArgument(sourceRepo);
        cmdLine.addArgument("-destination");
        cmdLine.addArgument(mirrorOutput.toURI().toString());
        return cmdLine;
    }
}

