/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.helpers;

import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.cmd.commands.DeployConsoleCommand;
import com.sap.core.deploy.client.cmd.helpers.Helper;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;

public class DisableCommandHelper
extends Helper {
    public static final int EXIT_CODE_DISABLE_FAILED = 53;

    public DisableCommandHelper(String account, DeployConsoleCommand command) {
        super(account, command);
    }

    public DisableCommandHelper(DeployConsoleCommand command) {
        super(command);
    }

    public void disable(String application, String component, String tenant) {
        if (!CheckHelper.checkArgsSpecifiedAccountApplicationHost(this.account, application, this.host)) {
            throw new HelpException("Invalid parameters", 123);
        }
        this.dumpParameters("disable", application, component, tenant);
        this.disableInternal(application, component, tenant);
    }

    public void disable(String applicationProcessId) {
        if (!CheckHelper.checkArgSpecified("-i", "--application-process-id", applicationProcessId)) {
            throw new HelpException("Invalid parameters", 123);
        }
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "application process ID", applicationProcessId);
        Collections.addAll(argsList, "host", this.host, "tenant", null);
        DumpHelper.dumpOperationList(this.user, "Requesting disable for:", argsList.toArray());
        this.disableInternal(applicationProcessId);
    }

    private void disableInternal(String application, String component, String tenant) {
        LifecycleResult lifecycleResult = null;
        this.initializeDeployClient();
        try {
            lifecycleResult = this.deployer.disable(application, component, this.host, tenant);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException("Disable failed", e, 53);
        }
        DeployDumpHelper.printAndCheckLifecycleResult("Disable", lifecycleResult, 53);
    }

    private void disableInternal(String applicationProcessId) {
        this.initializeDeployClient();
        LifecycleResult lifecycleResult = null;
        try {
            lifecycleResult = this.deployer.disable(applicationProcessId, this.host);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException("Disable failed", e, 53);
        }
        DeployDumpHelper.printAndCheckLifecycleResult("Disable", lifecycleResult, 53);
    }
}

