/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.helpers;

import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.cmd.commands.DeployConsoleCommand;
import com.sap.core.deploy.client.cmd.helpers.Helper;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;

public class EnableCommandHelper
extends Helper {
    public static final int EXIT_CODE_ENABLE_FAILED = 56;

    public EnableCommandHelper(String account, DeployConsoleCommand command) {
        super(account, command);
    }

    public EnableCommandHelper(DeployConsoleCommand command) {
        super(command);
    }

    public void enable(String application, String component, String tenant) {
        if (!CheckHelper.checkArgsSpecifiedAccountApplicationHost(this.account, application, this.host)) {
            throw new HelpException("Invalid parameters", 123);
        }
        this.dumpParameters("enable", application, component, tenant);
        this.enableInternal(application, component, tenant);
    }

    public void enable(String applicationProcessId) {
        if (!CheckHelper.checkArgSpecified("-i", "--application-process-id", applicationProcessId)) {
            throw new HelpException("Invalid parameters", 123);
        }
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "application process ID", applicationProcessId);
        Collections.addAll(argsList, "host", this.host, "tenant", null);
        DumpHelper.dumpOperationList(this.user, "Requesting enable for:", argsList.toArray());
        this.enableInternal(applicationProcessId);
    }

    private void enableInternal(String application, String component, String tenant) {
        LifecycleResult lifecycleResult = null;
        this.initializeDeployClient();
        try {
            lifecycleResult = this.deployer.enable(application, component, this.host, tenant);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException("Enable failed", e, 56);
        }
        DeployDumpHelper.printAndCheckLifecycleResult("Enable", lifecycleResult, 56);
    }

    private void enableInternal(String applicationProcessId) {
        this.initializeDeployClient();
        LifecycleResult lifecycleResult = null;
        try {
            lifecycleResult = this.deployer.enable(applicationProcessId, this.host);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException("Enable failed", e, 56);
        }
        DeployDumpHelper.printAndCheckLifecycleResult("Enable", lifecycleResult, 56);
    }
}

