/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.helpers;

import com.sap.core.deploy.client.DeployClient;
import com.sap.core.deploy.client.IDeployer;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.cmd.commands.DeployConsoleCommand;
import com.sap.core.deploy.client.cmd.helpers.ConsoleDeployFeedbackListener;
import com.sap.core.deploy.client.cmd.timeout.StartStopProgressMonitor;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.core.deploy.client.utils.DeployClientUtils;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.http.HttpException;

public abstract class Helper {
    static final String SERVICE_UNAVAILABLE_MSG = "Service is temporarily unavailable.";
    static final String OPERATION_FAILED_MSG = "%s failed. %s";
    static final String START_FAILED_MSG = "Start failed";
    String account;
    String host;
    IDeployer deployer;
    DeployConsoleCommand command;
    String user;

    protected Helper(String account, DeployConsoleCommand command) {
        this.account = account;
        this.host = command.getHost();
        this.user = command.getUser();
        this.command = command;
    }

    protected Helper(DeployConsoleCommand command) {
        this.host = command.getHost();
        this.user = command.getUser();
        this.command = command;
    }

    void initializeDeployClient() {
        this.command.askForPasswordAndInitHttpClient();
        if (this.deployer == null) {
            this.deployer = this.account != null ? DeployClient.getDeployInterface(this.account, this.command.getHttpClient(), new ConsoleDeployFeedbackListener(), "CMD Tools", null) : DeployClient.getDeployInterface(this.command.getHttpClient());
        }
    }

    protected void dumpAndExit(String msg, int exitCode, boolean statusCheck) {
        if (statusCheck) {
            DeployDumpHelper.dumpErrorMessage(msg);
            throw new CommandException(msg, exitCode);
        }
        DeployDumpHelper.dumpWarningMessage(msg);
    }

    protected StatusResult waitForStatus(IDeployer deployer, String applicationProcessId, String application, String component, Status status, int exitCode, boolean ignoreFailure) {
        try {
            StartStopProgressMonitor monitor = new StartStopProgressMonitor(applicationProcessId, this.account, application, component, status, deployer, this.host);
            StatusResult waitForStatusResult = monitor.waitForStatus();
            if (DeployClientUtils.isDefaultComponent(component)) {
                return deployer.getStatus(application, component, "0.0.0", this.host);
            }
            return waitForStatusResult;
        }
        catch (Exception e) {
            if (!ignoreFailure) {
                throw new CommandException("Waiting for status failed", e, exitCode);
            }
            return new StatusResult(e);
        }
    }

    protected void dumpParameters(String operation, String application, String component, String tenant) {
        ArrayList argsList = new ArrayList();
        if (component != null && !"web".equals(component)) {
            Collections.addAll(argsList, "component", component);
        }
        Collections.addAll(argsList, "application", application, "subaccount", this.account, "host", this.host, "tenant", tenant);
        DumpHelper.dumpOperationList(this.user, "Requesting " + operation + " for:", argsList.toArray());
    }

    protected void handleThrotllingMode(Exception e, String operation) throws CommandException {
        String causeMessage;
        if (null != e.getCause() && e.getCause() instanceof HttpException && null != (causeMessage = e.getCause().getMessage()) && causeMessage.contains(SERVICE_UNAVAILABLE_MSG)) {
            throw new CommandException(String.format(OPERATION_FAILED_MSG, operation, causeMessage), e);
        }
    }
}

