/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.helpers;

import com.sap.core.deploy.client.DeployResult;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.cmd.commands.DeployConsoleCommand;
import com.sap.core.deploy.client.cmd.helpers.DeployHelper;
import com.sap.core.deploy.client.cmd.timeout.HotUpdateProgressMonitor;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.core.deploy.client.cmd.util.DescriptorHelper;
import com.sap.core.deploy.client.utils.DeployClientUtils;
import com.sap.core.deploy.commons.hotupdate.Strategy;
import com.sap.core.jpaasrepository.api.Descriptor;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;

public class HotUpdateHelper
extends DeployHelper {
    public HotUpdateHelper(String account, DeployConsoleCommand command) {
        super(account, command);
    }

    public void hotUpdate(String application, String component, String source, String strategyString, boolean synchronousOperation, String uploadConnections, boolean delta) {
        boolean warsAndBundlesDetected;
        String[] deploymentLocations = DeployClientUtils.splitStringWithTrim(source, ",");
        HashMap<String, String> ignoredFilesAndReason = new HashMap<String, String>();
        try {
            warsAndBundlesDetected = DeployClientUtils.detectLocalWarFilesAndBundles(deploymentLocations, ignoredFilesAndReason).length > 0;
        }
        catch (IOException ioe) {
            throw new CommandException("I/O error occurred while verifying the provided source locations for deployment", ioe, 105);
        }
        catch (IllegalArgumentException e) {
            throw new CommandException("Invalid list of source locations, provided for deployment", e, 106);
        }
        if (!ignoredFilesAndReason.isEmpty()) {
            this.printIgnoredFiles(ignoredFilesAndReason);
        }
        if (this.checkArgsDeploy(this.account, application, component, source, this.host, null, null, warsAndBundlesDetected)) {
            Descriptor jpaasRepoDescriptor = DescriptorHelper.createDescriptor(source, null, "0.0.0", null, null, "ERROR", 1, 1, null, null, null, null, uploadConnections, null, null, null, "none", 10, "permanent_storage", null, null, null, delta, null);
            Strategy strategy = Strategy.fromOptionName(strategyString);
            if (strategy == null) {
                String errorMessage = "Invalid value in parameter --strategy. Acceptable values are: " + Strategy.getValues() + "\n";
                throw new CommandException(errorMessage, 40);
            }
            jpaasRepoDescriptor.set("hot-update", strategy.getIndex());
            this.hotUpdateOperation(application, component, jpaasRepoDescriptor, "Hot-update", synchronousOperation);
        }
    }

    private void hotUpdateOperation(String application, String component, Descriptor jpaasRepoDescriptor, String operation, boolean isSynchronous) {
        this.initializeDeployClient();
        StatusResult statusBeforeHotUpdate = null;
        if (isSynchronous) {
            statusBeforeHotUpdate = this.getStatus(application, component);
        }
        this.triggerHotUpdateOperation(application, component, jpaasRepoDescriptor, operation);
        if (isSynchronous) {
            System.out.println();
            this.waitForOperationToFinish(application, component, statusBeforeHotUpdate);
        } else {
            DeployDumpHelper.dumpWithDateNewLine("Triggered hot-update of application process\n\n");
        }
    }

    private StatusResult getStatus(String application, String component) throws CommandException {
        try {
            if (!"web".equalsIgnoreCase(component)) {
                return this.deployer.listAppComponentDetails(application, this.host).get(component);
            }
            return this.deployer.getStatus(application, component, "0.0.0", this.host);
        }
        catch (Exception e) {
            throw new CommandException("Getting application status before triggering hot-update failed", e, 113);
        }
    }

    private void triggerHotUpdateOperation(String application, String component, Descriptor jpaasRepoDescriptor, String operation) {
        DeployResult deployResult = null;
        try {
            DeployDumpHelper.dumpWithDateNewLine("Hot-update started...", new Date());
            DeployDumpHelper.LOGGER.info(operation + " started for [" + this.account + "/" + application + "/" + component + "] with descriptor [" + jpaasRepoDescriptor.toString() + "]");
            deployResult = this.deployer.deploy(application, component, "0.0.0", jpaasRepoDescriptor, this.host);
        }
        catch (Exception e) {
            throw new CommandException(operation + " failed", e, 108);
        }
        this.verifyDeployIsSuccessfull(operation, deployResult);
    }

    private void verifyDeployIsSuccessfull(String operation, DeployResult deployResult) {
        if (this.isDeployFailed(deployResult)) {
            DeployDumpHelper.printAndCheckDeployResult(operation, deployResult, 132, false);
            return;
        }
        DeployDumpHelper.dumpWithDateNewLine(deployResult.getMessage());
    }

    private boolean isDeployFailed(DeployResult deployResult) {
        return deployResult.getCode() != 0;
    }

    private void waitForOperationToFinish(String application, String component, StatusResult initialStatusResult) {
        StatusResult statusResult = this.waitForStatus(application, component, initialStatusResult, Status.STARTED, 122, false);
        DeployDumpHelper.printStatusResult(statusResult, component);
        if (statusResult.getCode() == 0) {
            DeployDumpHelper.dumpWithDateNewLine("Hot-update finished successfully\n", new Date());
        }
    }

    private StatusResult waitForStatus(String application, String component, StatusResult initialStatusResult, Status status, int exitCode, boolean ignoreFailure) {
        try {
            HotUpdateProgressMonitor monitor = new HotUpdateProgressMonitor(this.account, application, component, initialStatusResult, status, this.deployer, this.host);
            return monitor.waitForStatus();
        }
        catch (Exception e) {
            if (!ignoreFailure) {
                throw new CommandException("Waiting for status failed", e, exitCode);
            }
            return new StatusResult(e);
        }
    }
}

