/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.helpers;

import com.sap.core.deploy.client.RepositoryResult;
import com.sap.core.deploy.client.cmd.commands.DeployConsoleCommand;
import com.sap.core.deploy.client.cmd.helpers.Helper;
import com.sap.core.deploy.client.cmd.timeout.SynchronousProgressMonitor;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class ListEntityHelper
extends Helper {
    private static final String APPLICATIONS_LIST_MESSAGE = "Listing applications...";
    private static final String COMPONENTS_LIST_MESSAGE = "Listing components...";

    public ListEntityHelper(String account, DeployConsoleCommand command) {
        super(account, command);
    }

    public RepositoryResult getApplications() {
        this.initializeDeployClient();
        SynchronousProgressMonitor monitor = new SynchronousProgressMonitor(APPLICATIONS_LIST_MESSAGE);
        try {
            monitor.startMonitor();
            RepositoryResult repositoryResult = this.deployer.listAppliances(this.host);
            return repositoryResult;
        }
        catch (Exception e) {
            throw new CommandException("Application listing failed", e, 115);
        }
        finally {
            monitor.stopMonitor();
        }
    }

    public Set<String> getApplications(String pattern) {
        RepositoryResult repositoryResult = this.getApplications();
        if (repositoryResult.getCode() != 0) {
            throw new CommandException("Cannot list applications in subaccount [" + this.account + "]", 149);
        }
        String[] applications = repositoryResult.getEntities();
        Pattern applicationPattern = Pattern.compile(pattern);
        LinkedHashSet<String> matchingApplications = new LinkedHashSet<String>();
        for (String applicationName : applications) {
            if (!applicationPattern.matcher(applicationName).matches()) continue;
            matchingApplications.add(applicationName);
        }
        DeployDumpHelper.dumpWithDateNewLine("Found [" + matchingApplications.size() + "] applications");
        return matchingApplications;
    }

    public RepositoryResult getComponents(String application) {
        this.initializeDeployClient();
        SynchronousProgressMonitor monitor = new SynchronousProgressMonitor(COMPONENTS_LIST_MESSAGE);
        try {
            monitor.startMonitor();
            RepositoryResult repositoryResult = this.deployer.listComponents(application, this.host);
            return repositoryResult;
        }
        catch (Exception e) {
            throw new CommandException("Component listing failed", e, 117);
        }
        finally {
            monitor.stopMonitor();
        }
    }

    public Set<String> getComponents(String application, String pattern) {
        RepositoryResult repositoryResult = this.getComponents(application);
        if (repositoryResult.getCode() != 0) {
            throw new CommandException("Cannot list components in subaccount [" + this.account + "]", 150);
        }
        String[] components = repositoryResult.getEntities();
        Pattern componentPattern = Pattern.compile(pattern);
        LinkedHashSet<String> matchingComponents = new LinkedHashSet<String>();
        for (String componentName : components) {
            if (!componentPattern.matcher(componentName).matches()) continue;
            matchingComponents.add(componentName);
        }
        DeployDumpHelper.dumpWithDateNewLine("Found [" + matchingComponents.size() + "] components");
        return matchingComponents;
    }
}

