/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.helpers;

import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.cmd.commands.DeployConsoleCommand;
import com.sap.core.deploy.client.cmd.helpers.Helper;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;

public class SetClearDowntimeHelper
extends Helper {
    public static final int EXIT_CODE_SET_DOWNTIME_APP_FAILED = 57;
    public static final int EXIT_CODE_CLEAR_DOWNTIME_APP_FAILED = 58;

    public SetClearDowntimeHelper(String account, DeployConsoleCommand command) {
        super(account, command);
    }

    public void setDowntimeApp(String application, String component, String downtimeApplication, String tenant) {
        if (!CheckHelper.checkArgsSpecifiedForAppDowntime(this.account, application, component, this.host, downtimeApplication)) {
            throw new HelpException("Invalid parameters", 123);
        }
        this.dumpParameters("set-downtime-app", application, component, downtimeApplication, tenant);
        this.initializeDeployClient();
        LifecycleResult lifecycleResult = null;
        try {
            lifecycleResult = this.deployer.setDowntimeApp(application, component, this.host, downtimeApplication, tenant);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException("set-downtime-app failed", e, 57);
        }
        DeployDumpHelper.printAndCheckLifecycleResult("set-downtime-app", lifecycleResult, 57);
    }

    public void clearDowntimeApp(String application, String component, String tenant) {
        if (!CheckHelper.checkArgsSpecifiedAccountApplicationComponentHost(this.account, application, component, this.host)) {
            throw new HelpException("Invalid parameters", 123);
        }
        this.dumpParameters("clear-downtime-app", application, component, null, tenant);
        this.initializeDeployClient();
        LifecycleResult lifecycleResult = null;
        try {
            lifecycleResult = this.deployer.clearDowntimeApp(application, component, this.host, tenant);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException("clear-downtime-app failed", e, 58);
        }
        DeployDumpHelper.printAndCheckLifecycleResult("clear-downtime-app", lifecycleResult, 58);
    }

    private void dumpParameters(String operation, String application, String component, String downtimeApplication, String tenant) {
        ArrayList argsList = new ArrayList();
        if (!"web".equalsIgnoreCase(component)) {
            Collections.addAll(argsList, "component", component);
        }
        Collections.addAll(argsList, "application", application, "subaccount", this.account, "host", this.host, "downtime-application", downtimeApplication, "tenant", tenant);
        DumpHelper.dumpOperationList(this.user, "Requesting " + operation + " for:", argsList.toArray());
    }
}

