/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.helpers;

import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.cmd.commands.DeployConsoleCommand;
import com.sap.core.deploy.client.cmd.helpers.Helper;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.core.deploy.client.utils.DeployClientUtils;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;

public class StartStopHelper
extends Helper {
    public StartStopHelper(String account, DeployConsoleCommand command) {
        super(account, command);
    }

    public void start(String application, String component, String tenant, boolean synchronousOperation, boolean statusCheck, boolean ignoreFailure, boolean startDisabled) {
        if (!CheckHelper.checkArgsSpecifiedAccountApplicationComponentHost(this.account, application, component, this.host)) {
            throw new HelpException("Invalid parameters", 123);
        }
        this.dumpParameters("start", null, application, component, null, synchronousOperation, startDisabled);
        this.startInternal(application, component, tenant, synchronousOperation, statusCheck, ignoreFailure, startDisabled);
    }

    private void startInternal(String application, String component, String tenant, boolean synchronousOperation, boolean statusCheck, boolean ignoreFailure, boolean startDisabled) {
        LifecycleResult lifecycleResult;
        try {
            if (this.checkApplicationStatus(null, application, component, null, statusCheck)) {
                return;
            }
            this.initializeDeployClient();
            lifecycleResult = this.deployer.start(application, component, "0.0.0", this.host, tenant, startDisabled);
        }
        catch (CommandException ce) {
            if (!ignoreFailure) {
                throw ce;
            }
            lifecycleResult = new LifecycleResult(ce);
        }
        catch (Exception e) {
            if (!ignoreFailure) {
                this.handleThrotllingMode(e, "Start");
                throw new CommandException("Start failed", e, 121);
            }
            lifecycleResult = new LifecycleResult(e);
        }
        DeployDumpHelper.printAndCheckLifecycleResult("Start request", lifecycleResult, 135, ignoreFailure);
        if (synchronousOperation) {
            DeployDumpHelper.printStatusResult(this.waitForStatus(this.deployer, null, application, component, Status.STARTED, 122, ignoreFailure), component);
        }
    }

    public void stop(String applicationProcessId, boolean synchronousOperation, boolean statusCheck, boolean ignoreFailure) {
        if (!CheckHelper.isValueSpecified(applicationProcessId)) {
            throw new HelpException("Invalid parameters", 126);
        }
        this.dumpParameters("stop", applicationProcessId, null, null, null, synchronousOperation);
        this.stopInternal(applicationProcessId, null, null, null, synchronousOperation, statusCheck, ignoreFailure);
    }

    public void stop(String application, String component, String tenant, boolean synchronousOperation, boolean statusCheck, boolean ignoreFailure) {
        if (!CheckHelper.checkArgsSpecifiedAccountApplication(this.account, application)) {
            throw new HelpException("Invalid parameters", 126);
        }
        this.dumpParameters("stop", null, application, component, null, synchronousOperation);
        this.stopInternal(null, application, component, tenant, synchronousOperation, statusCheck, ignoreFailure);
    }

    private void stopInternal(String applicationProcessId, String application, String component, String tenant, boolean synchronousOperation, boolean statusCheck, boolean ignoreFailure) {
        LifecycleResult lifecycleResult;
        try {
            if (this.checkApplicationStatus(applicationProcessId, application, component, Status.STOPPED, statusCheck)) {
                return;
            }
            this.initializeDeployClient();
            lifecycleResult = applicationProcessId != null ? this.deployer.stop(applicationProcessId, this.host) : this.deployer.stop(application, component, "0.0.0", this.host, tenant);
        }
        catch (CommandException ce) {
            if (!ignoreFailure) {
                throw ce;
            }
            lifecycleResult = new LifecycleResult(ce);
        }
        catch (Exception e) {
            if (!ignoreFailure) {
                throw new CommandException("Stop failed", e, 124);
            }
            lifecycleResult = new LifecycleResult(e);
        }
        DeployDumpHelper.printAndCheckLifecycleResult("Stop request", lifecycleResult, 136, ignoreFailure);
        if (synchronousOperation) {
            this.waitForStatus(this.deployer, applicationProcessId, application, component, applicationProcessId == null ? Status.STOPPED : Status.NOT_FOUND, 125, ignoreFailure);
        }
    }

    public void restart(String applicationProcessId, String application, String component, String tenant, boolean synchronousOperation, boolean statusCheck, boolean ignoreFailure, boolean startDisabled) {
        if (!CheckHelper.checkArgsSpecifiedAccountApplicationComponentHost(this.account, application, component, this.host)) {
            throw new HelpException("Invalid parameters", 148);
        }
        this.dumpParameters("restart", applicationProcessId, application, component, tenant, synchronousOperation, startDisabled);
        this.stopInternal(applicationProcessId, application, component, tenant, true, statusCheck, ignoreFailure);
        this.startInternal(application, component, tenant, synchronousOperation, statusCheck, ignoreFailure, startDisabled);
    }

    public void dumpParameters(String operation, String applicationProcessId, String application, String component, String tenant, boolean synchronousOperation) {
        this.dumpParameters(operation, applicationProcessId, application, component, tenant, synchronousOperation, false);
    }

    public void dumpParameters(String operation, String applicationProcessId, String application, String component, String tenant, boolean synchronousOperation, boolean startDisabled) {
        ArrayList argsList = new ArrayList();
        if (component != null && !component.equalsIgnoreCase("web")) {
            Collections.addAll(argsList, "component", component);
        }
        Collections.addAll(argsList, "application process ID", applicationProcessId, "application", application, "subaccount", this.account, "host", this.host, "synchronous", synchronousOperation, "tenant", tenant);
        if (startDisabled) {
            Collections.addAll(argsList, "start disabled", startDisabled);
        }
        DumpHelper.dumpOperationList(this.user, "Requesting " + operation + " for:", argsList.toArray());
    }

    protected boolean checkApplicationStatus(String applicationProcessId, String application, String component, Status desiredStatus, boolean statusCheck) throws Exception {
        if (applicationProcessId == null) {
            CheckHelper.validateApplicationAndComponentArguments(application, component);
        } else {
            CheckHelper.validateApplicationProcessId(applicationProcessId);
        }
        this.initializeDeployClient();
        StatusResult status = applicationProcessId != null ? this.deployer.getStatus(applicationProcessId, this.host) : this.getApplicationStatus(application, component);
        StringBuilder msg = new StringBuilder(applicationProcessId != null ? "Application process with ID [" + applicationProcessId + "]" : "Application [" + application + "]");
        if (component != null && !component.equals("web")) {
            msg.append(", component [").append(component).append("]");
        }
        if (Status.NOT_FOUND.equals((Object)status.getStatus())) {
            msg.append(" not found");
            this.dumpAndExit(msg.toString(), 110, statusCheck);
            return true;
        }
        if (desiredStatus != null && desiredStatus.equals((Object)status.getStatus())) {
            msg.append(" already ").append(desiredStatus.name().toLowerCase());
            this.dumpAndExit(msg.toString(), 142, statusCheck);
            return true;
        }
        return false;
    }

    private StatusResult getApplicationStatus(String application, String component) throws Exception {
        if (DeployClientUtils.isDefaultComponent(component)) {
            return this.deployer.getStatusBasic(application, this.host);
        }
        return this.deployer.getStatus(application, component, "0.0.0", this.host);
    }
}

