/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.helpers;

import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.cmd.commands.DeployConsoleCommand;
import com.sap.core.deploy.client.cmd.helpers.Helper;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;

public class StartStopMaintenanceHelper
extends Helper {
    public static final int EXIT_CODE_START_MAINTENANCE_FAILED = 54;
    public static final int EXIT_CODE_STOP_MAINTENANCE_FAILED = 55;

    public StartStopMaintenanceHelper(String account, DeployConsoleCommand command) {
        super(account, command);
    }

    public void startMaintenance(String application, String component, String maintenanceApplication, String tenant, String directAccessCode) {
        if (!CheckHelper.checkArgsSpecifiedForAppMaintenance(this.account, application, component, this.host, maintenanceApplication, directAccessCode)) {
            throw new HelpException("Invalid parameters", 123);
        }
        this.dumpParameters("start-maintenance", application, component, maintenanceApplication, tenant, directAccessCode);
        this.startMaintenanceInternal(application, component, this.host, maintenanceApplication, tenant, directAccessCode);
    }

    public void stopMaintenance(String application, String component, String tenant) {
        if (!CheckHelper.checkArgsSpecifiedAccountApplicationComponentHost(this.account, application, component, this.host)) {
            throw new HelpException("Invalid parameters", 123);
        }
        this.dumpParameters("stop-maintenance", application, component, null, tenant, null);
        this.stopMaintenanceInternal(application, component, this.host, tenant);
    }

    private void startMaintenanceInternal(String application, String component, String host, String maintenanceApplication, String tenant, String directAccessCode) {
        this.initializeDeployClient();
        LifecycleResult lifecycleResult = null;
        try {
            lifecycleResult = this.deployer.startMaintenance(application, component, host, maintenanceApplication, tenant, directAccessCode);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException("Start-maintenance failed", e, 54);
        }
        DeployDumpHelper.printAndCheckLifecycleResult("start-maintenance", lifecycleResult, 54);
    }

    private void stopMaintenanceInternal(String application, String component, String host, String tenant) {
        this.initializeDeployClient();
        LifecycleResult lifecycleResult = null;
        try {
            lifecycleResult = this.deployer.stopMaintenance(application, component, host, tenant);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException("Stop-maintenance failed", e, 55);
        }
        DeployDumpHelper.printAndCheckLifecycleResult("stop-maintenance", lifecycleResult, 55);
    }

    private void dumpParameters(String operation, String application, String component, String maintenanceApplication, String tenant, String directAccessCode) {
        ArrayList argsList = new ArrayList();
        if (!"web".equalsIgnoreCase(component)) {
            Collections.addAll(argsList, "component", component);
        }
        Collections.addAll(argsList, "application", application, "subaccount", this.account, "host", this.host, "maintenance-application", maintenanceApplication, "tenant", tenant, "direct-access-code", directAccessCode);
        DumpHelper.dumpOperationList(this.user, "Requesting " + operation + " for:", argsList.toArray());
    }
}

