/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.helpers;

import com.sap.core.deploy.client.DeployResult;
import com.sap.core.deploy.client.RepositoryResult;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.cmd.commands.DeployConsoleCommand;
import com.sap.core.deploy.client.cmd.helpers.Helper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;

public class UndeployHelper
extends Helper {
    public UndeployHelper(String account, DeployConsoleCommand command) {
        super(account, command);
    }

    public void undeploy(String application, String component, boolean ignoreFailure) {
        DeployResult deployResult;
        this.dumpParameters("undeployment", application, component);
        this.initializeDeployClient();
        try {
            this.checkApplicationStatus(application, component);
            deployResult = component != null && !"web".equals(component) ? this.deployer.undeploy(application, component, "0.0.0", this.host) : this.deployer.undeploy(application, this.host);
        }
        catch (CommandException ce) {
            if (!ignoreFailure) {
                throw ce;
            }
            deployResult = new DeployResult(ce);
        }
        catch (Exception e) {
            if (!ignoreFailure) {
                throw new CommandException("Undeploy failed", e, 127);
            }
            deployResult = new DeployResult(e);
        }
        DeployDumpHelper.printAndCheckDeployResult("Undeployment", deployResult, 137, ignoreFailure);
    }

    public void dumpParameters(String operation, String application, String component) {
        ArrayList argsList = new ArrayList();
        if (component != null && !"web".equalsIgnoreCase(component)) {
            Collections.addAll(argsList, "component", component);
        }
        Collections.addAll(argsList, "application", application, "subaccount", this.account, "host", this.host);
        DumpHelper.dumpOperationList(this.user, "Requesting " + operation + " for:", argsList.toArray());
    }

    private void checkApplicationStatus(String application, String component) throws Exception {
        StatusResult status = null;
        if (component != null && !"web".equals(component)) {
            status = this.deployer.listAppComponentDetails(application, this.host).get(component);
            if (status == null) {
                status = new StatusResult(0, Status.NOT_FOUND, null);
            }
        } else {
            status = this.deployer.getStatus(application, "web", "0.0.0", this.host);
            if (Status.NOT_FOUND.equals((Object)status.getStatus())) {
                RepositoryResult res = this.deployer.listAppliances(this.host);
                for (String appName : res.getEntities()) {
                    if (!appName.equals(application)) continue;
                    return;
                }
            }
        }
        if (!Status.STOPPED.equals((Object)status.getStatus())) {
            StringBuilder msg = new StringBuilder("Application [" + application + "]");
            if (component != null) {
                msg.append(", component [").append(component).append("]");
            }
            if (Status.NOT_FOUND.equals((Object)status.getStatus())) {
                msg.append(" not found");
            } else {
                msg.append(" is not in STOPPED state");
            }
            DeployDumpHelper.printStatusResult(status, component);
            if (Status.NOT_FOUND.equals((Object)status.getStatus())) {
                throw new CommandException(msg.toString(), 140);
            }
            throw new CommandException(msg.toString(), 103);
        }
    }
}

