/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.timeout;

import com.sap.core.deploy.client.IDeployer;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.cmd.timeout.StartStopProgressMonitor;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.concurrent.ScheduledFuture;

public class HotUpdateProgressMonitor
extends StartStopProgressMonitor {
    protected static final int POLL_PERIOD = 1000;
    protected static final int INITIAL_DELAY = 500;
    public static final int MAX_FAILED_CHECKS = 30;

    public HotUpdateProgressMonitor(String account, String application, String component, StatusResult initialStatusResult, Status wantedStatus, IDeployer deployer, String host) {
        super(null, account, application, component, initialStatusResult, wantedStatus, deployer, host);
    }

    @Override
    public boolean progressCheck(ScheduledFuture progressHandler) throws CommandException {
        this.getCurrentStatus();
        if (this.currentStatus == null) {
            return false;
        }
        switch (this.currentStatus) {
            case STARTED: {
                if (this.wantedStatus.equals((Object)this.currentStatus)) {
                    return this.isProcessStatusChanged();
                }
                return this.checkForReachedMaxCountOfUnwantedStates();
            }
            case STARTING: 
            case STOPPING: {
                return false;
            }
        }
        return this.checkForReachedMaxCountOfUnwantedStates();
    }

    @Override
    protected boolean checkForReachedMaxCountOfUnwantedStates() throws CommandException {
        if (this.checksFailed >= 30) {
            throw new CommandException(String.format("[%s] Application [%s] is in status %s after %d ms", new Object[]{this.getCurrentTime(), this.application, this.currentStatus, this.monitor.getElapsedTime()}));
        }
        ++this.checksFailed;
        return false;
    }

    @Override
    protected boolean shouldExitImmediately() {
        return this.wantedStatus.equals((Object)this.currentStatus) && this.isProcessStatusChanged();
    }

    protected boolean isProcessStatusChanged() throws CommandException {
        if (this.hasOneApplicationProcess(this.initialStatusResult) && this.hasOneApplicationProcess(this.currentStatusResult)) {
            return this.initialStatusResult.getApplicationProcesses()[0].getLastStatusChange() != this.currentStatusResult.getApplicationProcesses()[0].getLastStatusChange();
        }
        throw new CommandException("Application " + this.getApplicationName() + " is started on more than one process");
    }

    private boolean hasOneApplicationProcess(StatusResult statusResult) {
        return statusResult != null && statusResult.getApplicationProcesses() != null && statusResult.getApplicationProcesses().length == 1;
    }

    private String getApplicationName() {
        String applicationName = this.application;
        if (this.component != null && this.component.length() > 0 && !"web".equals(this.component)) {
            applicationName = applicationName + "/" + this.component;
        }
        return applicationName;
    }

    @Override
    protected StatusResult getApplicationStatus() throws Exception {
        if (!"web".equalsIgnoreCase(this.component)) {
            return ((IDeployer)super.getProcessor()).listAppComponentDetails(this.application, this.host).get(this.component);
        }
        return ((IDeployer)super.getProcessor()).getStatus(this.application, this.component, "0.0.0", this.host);
    }
}

