/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.timeout;

import com.sap.core.deploy.client.IDeployer;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.core.deploy.client.utils.DeployClientUtils;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.progress.ProgressListener;
import com.sap.jpaas.infrastructure.console.progress.ProgressMonitor;
import com.sap.jpaas.infrastructure.console.progress.Spinner;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class StartStopProgressMonitor
extends ProgressListener<IDeployer, StatusResult> {
    protected static final int POLL_PERIOD = 500;
    protected static final int INITIAL_DELAY = 500;
    private static final String WAITING_FOR_STATUS_MESSAGE = "[%s] Waiting for %s status";
    private static final String STATUS_MESSAGE = "[%s] Status %s reached after %d ms";
    protected static final String ERROR_STATUS_MESSAGE = "[%s] Application [%s] is in status %s after %d ms";
    private static final String TIMEOUT_MESSAGE = "[%s] Application [%s] did not move into %s after %d ms";
    protected static final String STATUS_MESSAGE_WITH_PID = "[%s] Application process ID [%s] is in status %s after %d ms";
    private static final String TIMEOUT_MESSAGE_WITH_PID = "[%s] Application process ID [%s] did not move into %s after %d ms";
    public static final int MAX_FAILED_CHECKS = 5;
    public static final int MAX_FAILED_STATUS_PINGS = 3;
    private String account;
    protected String application;
    protected String component;
    private String applicationProcessId;
    protected String host;
    protected Status wantedStatus;
    protected Status currentStatus;
    protected Status initialStatus;
    protected StatusResult initialStatusResult;
    protected StatusResult currentStatusResult;
    protected ProgressMonitor monitor;
    int checksFailed = 0;
    int statusPingsFailed = 0;
    Status lastStatus;
    Status lastProgressStatus;

    public StartStopProgressMonitor(String applicationProcessId, String account, String application, String component, StatusResult initialStatusResult, Status wantedStatus, IDeployer deployer, String host) {
        this(applicationProcessId, account, application, component, wantedStatus, deployer, host);
        this.initialStatusResult = initialStatusResult;
        this.initialStatus = initialStatusResult.getStatus();
    }

    public StartStopProgressMonitor(String applicationProcessId, String account, String application, String component, Status wantedStatus, IDeployer deployer, String host) {
        this(wantedStatus, deployer, host);
        this.applicationProcessId = applicationProcessId;
        this.account = account;
        this.application = application;
        this.component = component;
    }

    private StartStopProgressMonitor(Status wantedStatus, IDeployer deployer, String host) {
        this.wantedStatus = wantedStatus;
        this.host = host;
        super.setProcessor(deployer);
    }

    public StatusResult waitForStatus() throws Exception {
        this.monitor = new ProgressMonitor();
        System.out.print(String.format(WAITING_FOR_STATUS_MESSAGE, new Object[]{new Date(), this.wantedStatus}));
        this.getCurrentStatus();
        if (this.initialStatusResult == null) {
            this.initialStatusResult = this.currentStatusResult;
            this.initialStatus = this.currentStatus;
        }
        if (this.shouldExitImmediately()) {
            this.finished();
            this.monitor.shutdown();
            return (StatusResult)super.getStatusCheck();
        }
        this.monitor.scheduleWithFixedDelay(new Spinner(new char[]{'.'}, false), 500L, 500L, TimeUnit.MILLISECONDS);
        ScheduledFuture progressHandler = this.monitor.startProgress(this, 3000L, 3000L, 900000L, 6000L, TimeUnit.MILLISECONDS);
        this.monitor.waitFor(progressHandler);
        if (this.monitor.isTimedOut()) {
            if (this.applicationProcessId != null) {
                throw new TimeoutException(String.format(TIMEOUT_MESSAGE_WITH_PID, new Object[]{new Date(System.currentTimeMillis()), this.applicationProcessId, this.wantedStatus, 900000}));
            }
            throw new TimeoutException(String.format(TIMEOUT_MESSAGE, new Object[]{new Date(System.currentTimeMillis()), this.component, this.wantedStatus, 900000}));
        }
        return (StatusResult)this.getStatusCheck();
    }

    protected boolean shouldExitImmediately() {
        return this.wantedStatus.equals((Object)this.currentStatus);
    }

    @Override
    public boolean progressCheck(ScheduledFuture progressHandler) throws CommandException {
        this.getCurrentStatus();
        if (this.currentStatus == null) {
            return false;
        }
        switch (this.currentStatus) {
            case STARTED: 
            case STOPPED: 
            case NOT_FOUND: {
                if (this.wantedStatus.equals((Object)this.currentStatus)) {
                    return true;
                }
                if (this.initialStatus.equals((Object)Status.STARTED) && this.wantedStatus.equals((Object)Status.STOPPED) && this.initialStatus.equals((Object)this.currentStatus)) {
                    return false;
                }
                return this.checkForReachedMaxCountOfUnwantedStates();
            }
            case STARTING: 
            case STOPPING: {
                return false;
            }
        }
        if (this.checksFailed >= 5) {
            throw new CommandException(String.format(ERROR_STATUS_MESSAGE, new Object[]{this.getCurrentTime(), this.application, this.currentStatus, this.monitor.getElapsedTime()}));
        }
        ++this.checksFailed;
        return false;
    }

    protected boolean checkForReachedMaxCountOfUnwantedStates() throws CommandException {
        if (this.checksFailed >= 5) {
            if (this.applicationProcessId != null) {
                throw new CommandException(String.format(STATUS_MESSAGE_WITH_PID, new Object[]{this.getCurrentTime(), this.applicationProcessId, this.currentStatus, this.monitor.getElapsedTime()}));
            }
            throw new CommandException(String.format(ERROR_STATUS_MESSAGE, new Object[]{this.getCurrentTime(), this.application, this.currentStatus, this.monitor.getElapsedTime()}));
        }
        ++this.checksFailed;
        return false;
    }

    protected Date getCurrentTime() {
        long time = System.currentTimeMillis();
        return new Date(time);
    }

    @Override
    public void progressNotification() {
        this.getCurrentStatus();
        if (this.currentStatus == null) {
            return;
        }
        if (!this.currentStatus.equals((Object)this.lastProgressStatus) && !this.currentStatus.equals((Object)this.wantedStatus)) {
            DumpHelper.dumpWithNewLine(String.format(STATUS_MESSAGE, new Object[]{new Date(), this.currentStatus, this.monitor.getElapsedTime()}));
            System.out.print(String.format(WAITING_FOR_STATUS_MESSAGE, new Object[]{new Date(), this.wantedStatus}));
            this.lastProgressStatus = this.currentStatus;
        }
    }

    protected void getCurrentStatus() {
        StatusResult result = null;
        try {
            result = this.applicationProcessId != null ? ((IDeployer)super.getProcessor()).getStatus(this.applicationProcessId, this.host) : this.getApplicationStatus();
            if (!result.getStatus().equals((Object)this.lastStatus)) {
                super.setStatusCheck(result);
                this.lastStatus = result.getStatus();
            }
        }
        catch (Exception e) {
            String errorText = "Cannot obtain status for " + (this.applicationProcessId != null ? "application process ID " + this.applicationProcessId : this.account + "/" + this.application + "/" + this.component);
            if (this.statusPingsFailed >= 3) {
                throw new CommandException(errorText, e);
            }
            ++this.statusPingsFailed;
            DeployDumpHelper.LOGGER.warn(errorText + ". Retrying [" + this.statusPingsFailed + " of " + 3 + "] ...", e);
        }
        if (result != null) {
            if (this.applicationProcessId != null ? 0 != result.getCode() && 4 != result.getCode() : 0 != result.getCode()) {
                throw new CommandException("Status check failed");
            }
            this.currentStatusResult = result;
            this.currentStatus = result.getStatus();
        }
    }

    protected StatusResult getApplicationStatus() throws Exception {
        if (DeployClientUtils.isDefaultComponent(this.component)) {
            return ((IDeployer)super.getProcessor()).getStatusBasic(this.application, this.host);
        }
        return ((IDeployer)super.getProcessor()).getStatus(this.application, this.component, "0.0.0", this.host);
    }

    @Override
    public void finished() {
        DumpHelper.dumpWithNewLine(String.format(STATUS_MESSAGE, new Object[]{new Date(), this.currentStatus, this.monitor.getElapsedTime()}));
        System.out.println();
    }

    @Override
    public void failed() {
    }
}

