/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.IllegalCharsetNameException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class ApplicationProcessId {
    private static final Pattern hex = Pattern.compile("[0-9a-f]+");
    private static final String CHARSET_NAME = "UTF-8";
    private final String processId;

    public ApplicationProcessId(String processId) {
        this.processId = processId;
    }

    public boolean isValid() {
        if (this.processId == null) {
            return false;
        }
        String normalizedProcessId = this.processId.trim().toLowerCase();
        return normalizedProcessId.length() >= 2 && normalizedProcessId.length() <= 40 && hex.matcher(normalizedProcessId).matches();
    }

    public String getNewProcessId() {
        String oldProcessId = this.getOldProcessId();
        String newProcessId = oldProcessId != null ? this.generateNewProcessId(oldProcessId) : this.processId;
        return newProcessId;
    }

    private String generateNewProcessId(String oldProcessId) {
        String sha1Hash = DigestUtils.shaHex(oldProcessId);
        return sha1Hash;
    }

    private String getOldProcessId() {
        StringTokenizer tokenizer;
        int tokensCount;
        String oldProcessId = null;
        String decodedProcessId = this.getDecodedProcessId();
        if (decodedProcessId != null && (tokensCount = (tokenizer = new StringTokenizer(decodedProcessId, ".")).countTokens()) > 3) {
            oldProcessId = decodedProcessId;
        }
        return oldProcessId;
    }

    private String getDecodedProcessId() {
        if (this.processId == null) {
            return null;
        }
        String decodedProcessId = null;
        try {
            byte[] decodedBytes = Base64.decodeBase64(this.processId.getBytes(CHARSET_NAME));
            decodedProcessId = new String(decodedBytes, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalCharsetNameException(CHARSET_NAME);
        }
        return decodedProcessId;
    }
}

