/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.util;

import com.beust.jcommander.ParameterException;
import com.sap.core.deploy.client.Result;
import com.sap.core.deploy.client.cmd.util.ApplicationProcessId;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class CheckHelper {
    public static final String KEY_VALUE_SEPARATOR = "=";
    public static final Pattern ALPHANUMERIC = Pattern.compile("[a-z0-9]+");
    public static final String ENVIRONMENT_VARIABLE_PREFIX = "_ENV_";
    private static final String INVALID_VALUE_OF_PARAMETER_EV_MESSAGE = "Invalid value of parameter --ev. Keys cannot contain spaces. If a value contains spaces, the pair must be enclosed in \"\". The following key-value pairs are not recognizable: ";
    private static final String DUPLICATE_VALUES_OF_PARAMETER_EV_MESSAGE = "Duplicate values of parameter --ev: ";
    private static final String SAME_VALUES_MESSAGE_START = "(*) Note that environment variables with keys ";
    private static final String SAME_VALUES_MESSAGE_END = " will set the same value.";

    public static void validateSpaceAccountArguments(String space, String account) {
        if (CheckHelper.isValueSpecified(space) && CheckHelper.isValueSpecified(account)) {
            throw new CommandException("Both --space and --account are specified. Use only --account", 129);
        }
    }

    public static void validateApplianceApplicationArguments(String appliance, String application) {
        if (CheckHelper.isValueSpecified(appliance) && CheckHelper.isValueSpecified(application)) {
            throw new CommandException("Both --appliance and --application are specified. Use only --application", 131);
        }
    }

    public static void validateApplicationArgument(String application) {
        SACValidator validator = new SACValidator();
        validator.validate("--application", application);
    }

    public static void validateApplicationAndComponentArguments(String application, String component) {
        SACValidator validator = new SACValidator();
        validator.validate("--application", application);
        validator.validate("--component", component);
    }

    public static void validateApplicationAndComponentArguments(Boolean regExp, String application, String component) {
        if (!regExp.booleanValue()) {
            CheckHelper.validateApplicationAndComponentArguments(application, component);
        }
    }

    public static boolean checkArgsListComponents(String account, String application, String host) {
        return CheckHelper.checkArgSpecified("-a", "--account", account) & CheckHelper.checkArgSpecified("-b", "--application", application) & CheckHelper.checkArgSpecified("-h", "--host", host);
    }

    public static boolean checkArgsListAppliances(String account, String host) {
        return CheckHelper.checkArgSpecified("-a", "--account", account) & CheckHelper.checkArgSpecified("-h", "--host", host);
    }

    public static boolean checkArgsSetUrl(String account, String application, String component, String host, String shortUrl) {
        return CheckHelper.checkArgsSpecifiedAccountApplicationComponentHost(account, application, component, host) & CheckHelper.checkArgSpecified("-x", "--url-prefix", shortUrl);
    }

    public static boolean checkArgsSpecifiedAccountApplication(String account, String application) {
        return CheckHelper.checkArgSpecified("-a", "--account", account) & CheckHelper.checkArgSpecified("-b", "--application", application);
    }

    public static boolean checkArgsSpecifiedAccountApplicationHost(String account, String application, String host) {
        return CheckHelper.checkArgSpecified("-a", "--account", account) & CheckHelper.checkArgSpecified("-b", "--application", application) & CheckHelper.checkArgSpecified("-h", "--host", host);
    }

    public static boolean checkArgsSpecifiedAccountApplicationComponentHost(String account, String application, String component, String host) {
        return CheckHelper.checkArgSpecified("-a", "--account", account) & CheckHelper.checkArgSpecified("-b", "--application", application) & CheckHelper.checkArgSpecified("-c", "--component", component) & CheckHelper.checkArgSpecified("-h", "--host", host);
    }

    public static boolean checkArgSpecified(String shortName, String longName, String value) {
        return CheckHelper.checkArgSpecified(shortName, longName, value, false);
    }

    public static boolean checkArgsSpecifiedForAppMaintenance(String account, String application, String component, String host, String maintenanceApplication, String directAccessCode) {
        return CheckHelper.checkArgsSpecifiedAccountApplicationComponentHost(account, application, component, host) & CheckHelper.checkArgSpecified(null, "--maintenance-application", maintenanceApplication) & CheckHelper.checkArgsSpecifiedForDirectAccessCode("--direct-access-code", directAccessCode);
    }

    public static boolean checkArgsSpecifiedForDirectAccessCode(String longName, String directAccessCode) {
        if (directAccessCode != null) {
            if (directAccessCode.length() > 100) {
                DeployDumpHelper.dumpErrorMessage(longName + " must have max length of " + 100);
                return false;
            }
            if (!directAccessCode.matches("[A-Za-z0-9]+")) {
                DeployDumpHelper.dumpErrorMessage(longName + " must be alphanumerical string");
                return false;
            }
        }
        return true;
    }

    public static boolean checkArgsSpecifiedForAppDowntime(String account, String application, String component, String host, String downtimeApplication) {
        return CheckHelper.checkArgsSpecifiedAccountApplicationComponentHost(account, application, component, host) & CheckHelper.checkArgSpecified(null, "--downtime-application", downtimeApplication);
    }

    public static boolean checkArgSpecified(String shortName, String longName, String value, boolean skipWarning) {
        if (value == null || value.trim().isEmpty()) {
            if (!skipWarning) {
                if (shortName != null) {
                    DeployDumpHelper.dumpErrorMessage(shortName + " or " + longName + " not specified");
                } else {
                    DeployDumpHelper.dumpErrorMessage(longName + " not specified");
                }
            }
            return false;
        }
        return true;
    }

    public static boolean isValueSpecified(String value) {
        return value != null && !value.trim().isEmpty();
    }

    public static boolean checkFolder(String folderString) {
        if (folderString != null && folderString.length() != 0) {
            File folder = new File(folderString);
            if (!folder.isDirectory()) {
                DeployDumpHelper.dumpWarningMessage("Configuration path '" + folder.getAbsolutePath() + "' " + (folder.exists() ? "does not exists" : "is not a directory"));
                return false;
            }
            DeployDumpHelper.dumpWarningMessage("Configuration upload functionality is deprecated and will be removed in the next version");
            return true;
        }
        return false;
    }

    public static boolean isResultOK(Result result) {
        return result != null && result.getCode() == 0;
    }

    public static boolean isResultForbidden(Result result) {
        return result.getCode() == 5;
    }

    public static void validateApplicationProcessId(String processId) {
        if (!new ApplicationProcessId(processId).isValid()) {
            throw new CommandException("Invalid application process ID. The value must consist of any number of hexadecimal characters between 2 and 40", 50);
        }
    }

    public static boolean isStackTracePresent(String stackTrace) {
        return stackTrace != null && !stackTrace.isEmpty() && !stackTrace.equals("[]");
    }

    public static Map<String, String> validateAndConvertEnvironmentVariablesToMetadataMap(Set<String> environmentVariables) {
        Map<String, String> metadataMap = null;
        if (environmentVariables != null && !environmentVariables.isEmpty()) {
            CheckHelper.validateEnvironmentVariablesList(environmentVariables);
            metadataMap = CheckHelper.convertToMetadataMap(environmentVariables);
        }
        return metadataMap;
    }

    private static void validateEnvironmentVariablesList(Set<String> environmentVariables) {
        ArrayList<String> invalidArguments = new ArrayList<String>();
        for (String environmentVariable : environmentVariables) {
            if (environmentVariable.contains(KEY_VALUE_SEPARATOR) && !environmentVariable.startsWith(KEY_VALUE_SEPARATOR) && !CheckHelper.checkIfKeyContainsSpaces(environmentVariable)) continue;
            invalidArguments.add(environmentVariable);
        }
        CheckHelper.handleInvalidKeys(invalidArguments);
    }

    private static boolean checkIfKeyContainsSpaces(String environmentVariable) {
        return CheckHelper.checkIfKeyContainsSpace(environmentVariable, ' ') || CheckHelper.checkIfKeyContainsSpace(environmentVariable, '\t');
    }

    private static boolean checkIfKeyContainsSpace(String environmentVariable, char space) {
        return environmentVariable.indexOf(space) > 0 && environmentVariable.indexOf(space) < environmentVariable.indexOf(KEY_VALUE_SEPARATOR);
    }

    private static Map<String, String> convertToMetadataMap(Set<String> environmentVariables) {
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        HashMap<String, Integer> duplicateKeysMap = new HashMap<String, Integer>();
        for (String environmentVariable : environmentVariables) {
            int keyValueSeparatorIndex = environmentVariable.indexOf(KEY_VALUE_SEPARATOR);
            String environmentVariableKey = environmentVariable.substring(0, keyValueSeparatorIndex);
            String environmentVariableValue = environmentVariable.substring(keyValueSeparatorIndex + 1);
            CheckHelper.populateMetadataMap(metadataMap, duplicateKeysMap, environmentVariableKey, environmentVariableValue);
        }
        CheckHelper.handleDuplicateKeys(duplicateKeysMap);
        return metadataMap;
    }

    private static void populateMetadataMap(Map<String, String> metadataMap, Map<String, Integer> invalidKeysMap, String environmentVariableKey, String environmentVariableValue) {
        if (!metadataMap.containsKey(ENVIRONMENT_VARIABLE_PREFIX + environmentVariableKey)) {
            metadataMap.put(ENVIRONMENT_VARIABLE_PREFIX + environmentVariableKey, environmentVariableValue);
        } else {
            CheckHelper.populateDuplicatedKeysMap(invalidKeysMap, environmentVariableKey);
        }
    }

    private static void populateDuplicatedKeysMap(Map<String, Integer> invalidKeysMap, String environmentVariableKey) {
        if (null != invalidKeysMap.get(environmentVariableKey)) {
            invalidKeysMap.put(environmentVariableKey, invalidKeysMap.get(environmentVariableKey) + 1);
        } else {
            invalidKeysMap.put(environmentVariableKey, 2);
        }
    }

    private static void handleInvalidKeys(List<String> invalidKeysList) {
        if (!invalidKeysList.isEmpty()) {
            throw new ParameterException(CheckHelper.constructInvalidValueMessage(invalidKeysList));
        }
    }

    private static String constructInvalidValueMessage(List<String> invalidArguments) {
        StringBuilder errorMessage = new StringBuilder("Invalid value of parameter --ev. Keys cannot contain spaces. If a value contains spaces, the pair must be enclosed in \"\". The following key-value pairs are not recognizable: \n");
        for (String invalidArgument : invalidArguments) {
            errorMessage.append("\t\t").append(invalidArgument).append("\n");
        }
        return errorMessage.toString();
    }

    private static void handleDuplicateKeys(Map<String, Integer> duplicateKeysMap) {
        if (!duplicateKeysMap.isEmpty()) {
            throw new ParameterException(CheckHelper.constructDuplicatedKeysMessage(duplicateKeysMap));
        }
    }

    private static String constructDuplicatedKeysMessage(Map<String, Integer> invalidKeysMap) {
        StringBuilder errorMessage = new StringBuilder("Duplicate values of parameter --ev: \n");
        for (String invalidKey : invalidKeysMap.keySet()) {
            errorMessage.append("\t\t[").append(invalidKey).append("] is specified [").append(invalidKeysMap.get(invalidKey)).append("] times \n");
        }
        return errorMessage.toString();
    }

    public static void dumpWarningMessageIfNeeded(Map<String, String> metadataMap) {
        if (null != metadataMap && !metadataMap.isEmpty() && CheckHelper.metadataMapContainsSameValues(metadataMap)) {
            Set<String> sameValuesKeySet = CheckHelper.findPairsWithSameValues(metadataMap);
            DumpHelper.dumpWithNewLine(CheckHelper.constructSameValuesMessage(sameValuesKeySet));
        }
    }

    protected static Set<String> findPairsWithSameValues(Map<String, String> metadataMap) {
        HashSet<String> keys = new HashSet<String>();
        ArrayList<String> valuesList = new ArrayList<String>(metadataMap.values());
        for (int i = 0; i < valuesList.size(); ++i) {
            String value1 = (String)valuesList.get(i);
            for (int j = i + 1; j < valuesList.size(); ++j) {
                String value2 = (String)valuesList.get(j);
                if (!value1.equals(value2)) continue;
                keys.addAll(CheckHelper.getKeys(value1, metadataMap));
            }
        }
        return keys;
    }

    private static Set<String> getKeys(String value, Map<String, String> metadataMap) {
        HashSet<String> keys = new HashSet<String>();
        for (String key : metadataMap.keySet()) {
            if (!metadataMap.get(key).equals(value)) continue;
            keys.add(key);
        }
        return keys;
    }

    protected static boolean metadataMapContainsSameValues(Map<String, String> metadataMap) {
        Collection<String> valuesCollection = metadataMap.values();
        HashSet<String> valuesSet = new HashSet<String>(metadataMap.values());
        return valuesCollection.size() != valuesSet.size();
    }

    protected static String constructSameValuesMessage(Set<String> sameValuesKeySet) {
        StringBuilder message = new StringBuilder(SAME_VALUES_MESSAGE_START);
        ArrayList<String> sameValuesKeyList = new ArrayList<String>(sameValuesKeySet);
        int listSize = sameValuesKeyList.size();
        for (int i = 0; i < listSize; ++i) {
            String key = ((String)sameValuesKeyList.get(i)).substring(5);
            if (i == listSize - 1) {
                message.append(key);
                continue;
            }
            if (i == listSize - 2) {
                message.append(key).append(" and ");
                continue;
            }
            message.append(key).append(", ");
        }
        message.append(SAME_VALUES_MESSAGE_END);
        return message.toString();
    }
}

