/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.util;

import com.sap.core.deploy.client.DeployResult;
import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.RepositoryResult;
import com.sap.core.deploy.client.Result;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.cmd.util.ApplicationProcessId;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.commons.ApplicationProcessResource;
import com.sap.core.deploy.commons.status.LBStatus;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class DeployDumpHelper {
    private static final String LABEL_ID = "ID";
    private static final String LABEL_STATE = "State";
    private static final String LABEL_LAST_CHANGE = "Last Change";
    private static final String LABEL_RUNTIME = "Runtime";
    private static final String LABEL_AVAILABILITY_ZONE = "Availability Zone";
    private static final String STATUS_MAIN_LABEL = "Status";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final String OFFSET = "  ";
    static final String SEP = "   ";
    private static final String FINISHED_WITH_ERROR = " finished with error";
    private static final String FINISHED_SUCCESSFULLY = " finished successfully";
    private static final String DATE_STRING = "%n[%s] ";
    public static Logger LOGGER = Logger.getLogger(DeployDumpHelper.class);
    private static final String dateFormat = "dd-MMM-yyyy HH:mm:ss";
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    private static final String validUntilFormat = "dd-MMM-yyyy";
    private static final SimpleDateFormat validUntilFormatter = new SimpleDateFormat("dd-MMM-yyyy");
    private static final int DEFAULT_PROCESSID_LENGTH = 7;
    private static final int FULL_PROCESSID_LENGTH = 40;
    public static final int EXIT_CODE_NOT_FOUND = 51;

    public static void dumpWithDate(CharSequence message) {
        if (message == null || message.length() == 0) {
            return;
        }
        System.out.print(String.format(DATE_STRING + message, new Date()));
    }

    public static void dumpWithDate(CharSequence message, Date date) {
        if (message == null || message.length() == 0) {
            return;
        }
        System.out.print(String.format(DATE_STRING + message, date));
    }

    public static void dumpWithDateNewLine(CharSequence message) {
        if (message == null || message.length() == 0) {
            return;
        }
        System.out.println(String.format(DATE_STRING + message, new Date()));
    }

    public static void dumpWithDateNewLine(CharSequence message, Date date) {
        if (message == null || message.length() == 0) {
            return;
        }
        System.out.println(String.format(DATE_STRING + message, date));
    }

    public static String getKeyValueMessage(CharSequence key, Object value) {
        return key + ": " + value.toString();
    }

    public static void dumpWithNewLine(CharSequence message) {
        if (message == null || message.length() == 0) {
            return;
        }
        System.out.println();
        System.out.println(message);
    }

    public static void dump(CharSequence message) {
        if (message == null || message.length() == 0) {
            return;
        }
        System.out.print(message);
    }

    public static void dumpErrorMessage(CharSequence msg) {
        DeployDumpHelper.dumpMessage(msg, "Error: ");
    }

    public static void dumpWarningMessage(CharSequence msg) {
        DeployDumpHelper.dumpMessage(msg, "Warning: ");
    }

    public static void dumpMessage(CharSequence message, CharSequence severity) {
        if (message == null || message.length() == 0) {
            return;
        }
        System.err.println(LINE_SEPARATOR + severity + message + LINE_SEPARATOR);
    }

    public static void printStatusResult(StatusResult statusResult, String componentName) {
        DeployDumpHelper.printStatusResult(statusResult, componentName, false);
    }

    public static void printStatusResult(StatusResult statusResult, String componentName, boolean showFullProcessId) {
        DeployDumpHelper.printStatusResult(statusResult, componentName, 0, showFullProcessId);
    }

    public static void printStatusResultFromProcess(StatusResult statusResult, boolean showFullProcessId) {
        String stackTrace = statusResult.getStackTrace();
        if (CheckHelper.isStackTracePresent(stackTrace)) {
            LOGGER.warn("Status check failed with: " + stackTrace);
        }
        StringBuilder statusText = new StringBuilder(statusResult.getStatus().toString());
        String resultMessage = statusResult.getMessage();
        if (!statusText.toString().equals(resultMessage)) {
            String title = DeployDumpHelper.getMessageTitle(statusResult);
            statusText = statusText.append(" (").append(title).append(")");
        }
        System.out.println(DeployDumpHelper.getKeyValueMessage(STATUS_MAIN_LABEL, statusText));
        ApplicationProcessResource[] applicationProcesses = statusResult.getApplicationProcesses();
        if (applicationProcesses != null) {
            if (applicationProcesses.length == 1) {
                DeployDumpHelper.printApplicationProcessID(applicationProcesses, showFullProcessId);
                System.out.println();
            } else {
                throw new IllegalStateException("FATAL ERROR: expected a single application process ID as response to a status request of a single application process but received " + applicationProcesses.length);
            }
        }
    }

    public static String getMessageTitle(Result result) {
        String message = result.getMessage();
        int lineBreakPos = message.indexOf(10);
        if (lineBreakPos == -1) {
            return message;
        }
        String title = message.substring(0, lineBreakPos);
        return title;
    }

    public static String getMessageDetails(Result result) {
        String message = result.getMessage();
        int lineBreakPos = message.indexOf(10);
        if (lineBreakPos == -1) {
            return message;
        }
        String details = message.substring(lineBreakPos + 1);
        return details;
    }

    public static void printStatusResult(StatusResult statusResult, String componentName, int maxLength) {
        DeployDumpHelper.printStatusResult(statusResult, componentName, maxLength, false);
    }

    public static void printStatusResult(StatusResult statusResult, String componentName, int maxLength, boolean showFullProcessId) {
        String downtimeApplication;
        String stackTrace = statusResult.getStackTrace();
        if (CheckHelper.isStackTracePresent(stackTrace)) {
            LOGGER.warn("Status check failed with: " + stackTrace);
        }
        String titleOffsetString = "";
        String infoOffsetString = "";
        if (maxLength > 0 && componentName != null) {
            char[] offsetChars = new char[maxLength - componentName.length()];
            Arrays.fill(offsetChars, ' ');
            titleOffsetString = new String(offsetChars);
            offsetChars = new char[maxLength + OFFSET.length()];
            Arrays.fill(offsetChars, ' ');
            infoOffsetString = new String(offsetChars);
        }
        StringBuilder statusText = new StringBuilder(statusResult.getStatus().toString());
        String resultMessage = statusResult.getMessage();
        if (!statusText.toString().equals(resultMessage)) {
            statusText = statusText.append(" (").append(statusResult.getMessage()).append(")");
        }
        String status_label = componentName == null ? STATUS_MAIN_LABEL : titleOffsetString + componentName;
        status_label = status_label.replace(STATUS_MAIN_LABEL, STATUS_MAIN_LABEL);
        System.out.println(DeployDumpHelper.getKeyValueMessage(status_label, statusText));
        if (statusResult.getLBStatus() == LBStatus.IN_MAINTENANCE) {
            DeployDumpHelper.dumpWithNewLine(infoOffsetString + "Maintenance application: " + statusResult.getMaintenanceApplication());
        }
        if ((downtimeApplication = statusResult.getDowntimeApplication()) != null) {
            DeployDumpHelper.dumpWithNewLine(infoOffsetString + "Downtime application: " + downtimeApplication);
        }
        if (componentName != null) {
            String[] urls;
            String bestUrl = statusResult.getUrl();
            if (bestUrl != null) {
                DeployDumpHelper.dumpWithNewLine(DeployDumpHelper.getKeyValueMessage(infoOffsetString + "URL", bestUrl));
            }
            if ((urls = statusResult.getUrls()) != null) {
                DeployDumpHelper.dumpWithNewLine(infoOffsetString + "Access points:");
                if (urls.length != 0) {
                    for (String url : urls) {
                        System.out.println(infoOffsetString + OFFSET + url);
                    }
                } else if (bestUrl != null) {
                    System.out.println(infoOffsetString + OFFSET + bestUrl);
                } else {
                    System.out.println(infoOffsetString + OFFSET + "not available");
                }
            }
            ApplicationProcessResource[] applicationProcesses = statusResult.getApplicationProcesses();
            DeployDumpHelper.printRuntimeWithMessage(statusResult);
            DeployDumpHelper.printApplicationProcesses(applicationProcesses, true, infoOffsetString, showFullProcessId);
        }
        System.out.println();
    }

    public static void printRepoResult(String operationName, RepositoryResult repositoryResult) {
        String[] entities;
        String resultMessage = repositoryResult.getMessage();
        String stackTrace = repositoryResult.getStackTrace();
        if (repositoryResult.getCode() == 0) {
            System.out.println(operationName);
        } else {
            DeployDumpHelper.dumpWithNewLine(operationName + FINISHED_WITH_ERROR);
            if (resultMessage != null && !resultMessage.isEmpty()) {
                System.out.println(resultMessage);
            }
        }
        if (CheckHelper.isStackTracePresent(stackTrace)) {
            LOGGER.warn(operationName + " failed with: " + stackTrace);
        }
        if ((entities = repositoryResult.getEntities()) != null && entities.length > 0) {
            for (String entity : entities) {
                System.out.println(OFFSET + entity);
            }
        } else {
            DeployDumpHelper.dumpWithNewLine("There are no deployed entities to display");
        }
        System.out.println();
    }

    public static void printRuntimeTypesResult(String operationName, List<String> runtimes) {
        System.out.println(operationName);
        if (runtimes.isEmpty()) {
            DeployDumpHelper.dumpWithNewLine("No available runtimes");
        } else {
            for (String runtime : runtimes) {
                System.out.println(OFFSET + runtime);
            }
        }
        System.out.println();
    }

    public static void printAndCheckLifecycleResult(String operationName, LifecycleResult lifecycleResult, int exitCode, boolean ignoreFailure) {
        String resultMessage = lifecycleResult.getMessage();
        String stackTrace = lifecycleResult.getStackTrace();
        Status status = lifecycleResult.getStatus();
        if (lifecycleResult.getCode() == 0) {
            DeployDumpHelper.dumpWithDateNewLine(operationName + " performed successfully.");
            System.out.println();
        } else {
            DeployDumpHelper.dumpWithDateNewLine(operationName + FINISHED_WITH_ERROR);
            System.out.println();
        }
        DeployDumpHelper.logStackTrace(operationName, resultMessage, stackTrace);
        StringBuilder message = new StringBuilder();
        DeployDumpHelper.addResultMessage(message, resultMessage);
        if (DeployDumpHelper.shouldPrintStatus(lifecycleResult, status)) {
            DeployDumpHelper.appendWithNewLine(message, DeployDumpHelper.getKeyValueMessage(STATUS_MAIN_LABEL, (Object)status));
        }
        DeployDumpHelper.produceException(lifecycleResult, exitCode, ignoreFailure, stackTrace, message);
        System.out.println(message);
    }

    public static void addEnvVariablesToArgsList(List<Object> argsList, Set<String> environmentVariables) {
        if (null != environmentVariables && !environmentVariables.isEmpty()) {
            TreeSet<String> sortedEnvVariables = new TreeSet<String>();
            sortedEnvVariables.addAll(environmentVariables);
            Collections.addAll(argsList, "environment variables", sortedEnvVariables);
        }
    }

    private static boolean shouldPrintStatus(LifecycleResult lifecycleResult, Status status) {
        return CheckHelper.isResultOK(lifecycleResult) || status != Status.UNKNOWN;
    }

    public static void printAndCheckLifecycleResult(String operationName, LifecycleResult lifecycleResult, int exitCode) {
        String resultMessage = lifecycleResult.getMessage();
        String stackTrace = lifecycleResult.getStackTrace();
        DeployDumpHelper.logStackTrace(operationName, resultMessage, stackTrace);
        if (lifecycleResult.getCode() == 0) {
            DeployDumpHelper.dumpWithNewLine(resultMessage != null ? resultMessage : operationName + " performed successfully.");
        } else if (lifecycleResult.getCode() == 5 && lifecycleResult.getStatus() == Status.STARTED) {
            DeployDumpHelper.dumpWithNewLine("Warning: " + resultMessage);
        } else {
            if (Status.NOT_FOUND.equals((Object)lifecycleResult.getStatus())) {
                throw new CommandException(DeployDumpHelper.getMessageDetails(lifecycleResult), 51);
            }
            throw new CommandException(lifecycleResult.getMessage(), exitCode);
        }
    }

    private static void addResultMessage(StringBuilder result, String message) {
        if (message != null && !message.isEmpty()) {
            DeployDumpHelper.appendWithNewLine(result, message);
        }
    }

    private static void logStackTrace(String operationName, String resultMessage, String stackTrace) {
        if (CheckHelper.isStackTracePresent(stackTrace)) {
            if (resultMessage != null && !resultMessage.isEmpty()) {
                LOGGER.warn(operationName + " failed with [" + resultMessage + "]: " + stackTrace);
            } else {
                LOGGER.warn(operationName + " failed with: " + stackTrace);
            }
        }
    }

    private static void produceException(Result result, int exitCode, boolean ignoreFailure, String stackTrace, CharSequence message) {
        if (!ignoreFailure && !CheckHelper.isResultOK(result)) {
            throw new CommandException(message.toString(), exitCode);
        }
    }

    public static void printAndCheckDeployResult(String operationName, DeployResult deployResult, int exitCode, boolean ignoreFailure) {
        DeployDumpHelper.printAndCheckDeployResult(operationName, deployResult, exitCode, ignoreFailure, true);
    }

    public static void printAndCheckDeployResult(String operationName, DeployResult deployResult, int exitCode, boolean ignoreFailure, boolean printNewLine) {
        String resultMessage = deployResult.getMessage();
        String stackTrace = deployResult.getStackTrace();
        if (deployResult.getCode() == 0) {
            DeployDumpHelper.dumpWithDate(operationName + FINISHED_SUCCESSFULLY);
        } else {
            DeployDumpHelper.dumpWithDate(operationName + FINISHED_WITH_ERROR);
        }
        if (printNewLine) {
            System.out.println();
        }
        DeployDumpHelper.logStackTrace(operationName, resultMessage, stackTrace);
        StringBuilder message = new StringBuilder();
        DeployDumpHelper.addResultMessage(message, resultMessage);
        DeployDumpHelper.produceException(deployResult, exitCode, ignoreFailure, stackTrace, message);
        DeployDumpHelper.dumpWithNewLine(message.toString());
    }

    private static void appendWithNewLine(StringBuilder result, String message) {
        result.append(message).append(LINE_SEPARATOR);
    }

    private static void printApplicationProcesses(ApplicationProcessResource[] applicationProcesses, boolean printTitle, String infoOffsetString, boolean showFullProcessId) {
        if (applicationProcesses == null || applicationProcesses.length == 0) {
            return;
        }
        DeployDumpHelper.transformOldProcessId(applicationProcesses);
        DeployDumpHelper.sortApplicationProcessesInChronologicalOrder(applicationProcesses);
        System.out.println();
        if (printTitle) {
            System.out.println(infoOffsetString + "Application processes:");
        }
        int maxStatusLength = DeployDumpHelper.getMaxStatusLength(applicationProcesses);
        int maxRuntimeVersionLength = DeployDumpHelper.getMaxRuntimeVersionLength(applicationProcesses);
        int maxAvailabilityZoneLength = DeployDumpHelper.getMaxAvailabilityZoneLength(applicationProcesses);
        System.out.println(infoOffsetString + OFFSET + String.format("%1$-" + (OFFSET.length() + (showFullProcessId ? 40 : 7) + SEP.length()) + "s" + "%2$-" + (maxStatusLength + OFFSET.length() + SEP.length()) + "s" + "%3$-" + (dateFormat.length() + OFFSET.length() + SEP.length()) + "s" + "%4$-" + (maxRuntimeVersionLength + OFFSET.length() + SEP.length()) + "s" + "%5$-" + (maxAvailabilityZoneLength + OFFSET.length() + SEP.length()) + "s", LABEL_ID, LABEL_STATE, LABEL_LAST_CHANGE, LABEL_RUNTIME, LABEL_AVAILABILITY_ZONE));
        for (ApplicationProcessResource applicationProcess : applicationProcesses) {
            Date lastStatusChange;
            String status = applicationProcess.getStatus();
            LBStatus lbStatus = LBStatus.fromString(applicationProcess.getLbStatus());
            if (lbStatus == LBStatus.DISABLED || lbStatus == LBStatus.OFFLINE) {
                status = status + " (disabled)";
            }
            String processId = applicationProcess.getProcessId();
            if (!showFullProcessId) {
                processId = processId.substring(0, Math.min(7, processId.length()));
            }
            String formattedLastStatusChange = (lastStatusChange = new Date(applicationProcess.getLastStatusChange())).getTime() > 0L ? dateFormatter.format(lastStatusChange) : "";
            String runtimeVersion = DeployDumpHelper.getRuntimeWithRecommendation(applicationProcess);
            String availabilityZone = applicationProcess.getAvailabilityZone();
            System.out.println(infoOffsetString + OFFSET + processId + SEP + OFFSET + String.format("%1$-" + maxStatusLength + "s", status) + SEP + OFFSET + formattedLastStatusChange + SEP + OFFSET + String.format("%1$-" + maxRuntimeVersionLength + "s", runtimeVersion) + SEP + OFFSET + String.format("%1$-" + maxAvailabilityZoneLength + "s", availabilityZone));
        }
    }

    private static void printApplicationProcessID(ApplicationProcessResource[] applicationProcesses, boolean showFullProcessId) {
        if (applicationProcesses == null || applicationProcesses.length == 0) {
            return;
        }
        DeployDumpHelper.transformOldProcessId(applicationProcesses);
        DeployDumpHelper.sortApplicationProcessesInChronologicalOrder(applicationProcesses);
        System.out.println();
        int maxTitleLength = DeployDumpHelper.getMaxTitleLength(LABEL_ID, LABEL_STATE, LABEL_LAST_CHANGE, LABEL_RUNTIME, LABEL_AVAILABILITY_ZONE);
        for (ApplicationProcessResource applicationProcess : applicationProcesses) {
            Date lastStatusChange;
            String status = applicationProcess.getStatus();
            status = DeployDumpHelper.addLbStatus(status, applicationProcess);
            String processId = applicationProcess.getProcessId();
            if (!showFullProcessId) {
                processId = processId.substring(0, Math.min(7, processId.length()));
            }
            String formattedLastStatusChange = (lastStatusChange = new Date(applicationProcess.getLastStatusChange())).getTime() > 0L ? dateFormatter.format(lastStatusChange) : "";
            String availabilityZone = applicationProcess.getAvailabilityZone();
            Map<String, String> runtime = applicationProcess.getRuntime();
            String runtimeVersion = DeployDumpHelper.getRuntimeVerWithValidUntilDate(runtime, false);
            System.out.println(String.format("%1$-" + maxTitleLength + "s : %2$s", LABEL_ID, processId));
            System.out.println(String.format("%1$-" + maxTitleLength + "s : %2$s", LABEL_STATE, status));
            System.out.println(String.format("%1$-" + maxTitleLength + "s : %2$s", LABEL_LAST_CHANGE, formattedLastStatusChange));
            System.out.println(String.format("%1$-" + maxTitleLength + "s : %2$s", LABEL_RUNTIME, runtimeVersion));
            System.out.println(String.format("%1$-" + maxTitleLength + "s : %2$s", LABEL_AVAILABILITY_ZONE, availabilityZone));
            String warnMessage = applicationProcess.getMessage();
            if (warnMessage == null || warnMessage.isEmpty()) continue;
            DeployDumpHelper.dumpMessage(warnMessage, "");
        }
    }

    private static int getMaxTitleLength(String ... titles) {
        int max = -1;
        for (String title : titles) {
            max = Math.max(max, title.length());
        }
        return max;
    }

    private static int getMaxStatusLength(ApplicationProcessResource[] applicationProcesses) {
        int maxStatusLength = 0;
        for (ApplicationProcessResource applicationProcess : applicationProcesses) {
            String status = applicationProcess.getStatus();
            status = DeployDumpHelper.addLbStatus(status, applicationProcess);
            maxStatusLength = Math.max(maxStatusLength, status.length());
        }
        return maxStatusLength;
    }

    private static int getMaxRuntimeVersionLength(ApplicationProcessResource[] applicationProcesses) {
        int maxRuntimeVersionLength = LABEL_RUNTIME.length();
        for (ApplicationProcessResource applicationProcess : applicationProcesses) {
            String runtimeVersion = DeployDumpHelper.getRuntimeWithRecommendation(applicationProcess);
            if (runtimeVersion == null) continue;
            maxRuntimeVersionLength = Math.max(maxRuntimeVersionLength, runtimeVersion.length());
        }
        return maxRuntimeVersionLength;
    }

    private static int getMaxAvailabilityZoneLength(ApplicationProcessResource[] applicationProcesses) {
        int maxAvailabilityZoneLength = LABEL_AVAILABILITY_ZONE.length();
        for (ApplicationProcessResource applicationProcess : applicationProcesses) {
            maxAvailabilityZoneLength = Math.max(maxAvailabilityZoneLength, applicationProcess.getAvailabilityZone().length());
        }
        return maxAvailabilityZoneLength;
    }

    private static String addLbStatus(String status, ApplicationProcessResource applicationProcess) {
        LBStatus lbStatus = LBStatus.fromString(applicationProcess.getLbStatus());
        if (lbStatus == LBStatus.DISABLED || lbStatus == LBStatus.OFFLINE) {
            status = status + " (disabled)";
        }
        return status;
    }

    private static String getRuntimeWithRecommendation(ApplicationProcessResource applicationProcess) {
        Map<String, String> runtime = applicationProcess.getRuntime();
        String runtimeVersion = null;
        if (runtime != null) {
            runtimeVersion = runtime.get("version");
            if (runtimeVersion != null) {
                String recommendationString = runtime.get("state");
                if (recommendationString != null && !recommendationString.equals("recommended")) {
                    runtimeVersion = runtimeVersion + " (!)";
                }
                runtimeVersion = DeployDumpHelper.addPrefix(runtimeVersion, runtime, false);
            } else {
                runtimeVersion = "unknown";
            }
        }
        return runtimeVersion;
    }

    private static void printRuntimeWithMessage(StatusResult statusResult) {
        Map<String, String> runtime = statusResult.getDeployRuntime();
        String runtimeVersion = DeployDumpHelper.getRuntimeVerWithValidUntilDate(runtime, true);
        if (runtimeVersion.equals("")) {
            return;
        }
        System.out.println();
        System.out.println("Runtime: " + runtimeVersion);
    }

    protected static String getRuntimeVerWithValidUntilDate(Map<String, String> runtime, boolean shortVersion) {
        String runtimeVersion = DeployDumpHelper.getRuntimeVersion(runtime, shortVersion);
        if (!runtimeVersion.equals("unknown")) {
            boolean isPinnedToMajorVersion = runtimeVersion.length() == 1;
            runtimeVersion = DeployDumpHelper.addPrefix(runtimeVersion, runtime, shortVersion);
            if (!isPinnedToMajorVersion) {
                runtimeVersion = runtimeVersion + " (";
                String validityState = runtime.get("state");
                if (validityState.equals("expired")) {
                    runtimeVersion = runtimeVersion + "expired, update to a recommended version";
                } else {
                    if (validityState.equals("deprecated")) {
                        runtimeVersion = runtimeVersion + "deprecated, ";
                    }
                    runtimeVersion = runtimeVersion + "valid until ";
                    String expirationDate = runtime.get("expDate");
                    Date validUntil = new Date(Long.valueOf(expirationDate));
                    runtimeVersion = runtimeVersion + validUntilFormatter.format(validUntil);
                }
                runtimeVersion = runtimeVersion + ")";
            }
        }
        return runtimeVersion;
    }

    private static String addPrefix(String runtimeVersion, Map<String, String> runtime, boolean shortVersion) {
        String dispalyName = runtime.get("displayName");
        if (dispalyName != null) {
            if (shortVersion) {
                runtimeVersion = dispalyName + ", " + runtimeVersion;
            } else {
                String externalRuntimeId = runtime.get("id");
                runtimeVersion = externalRuntimeId + " " + runtimeVersion;
            }
        }
        return runtimeVersion;
    }

    private static String getRuntimeVersion(Map<String, String> runtime, boolean shortVersion) {
        String runtimeVersion;
        if (runtime == null) {
            runtimeVersion = "unknown";
        } else {
            runtimeVersion = runtime.get("version");
            if (runtimeVersion == null) {
                runtimeVersion = "unknown";
            } else if (shortVersion && runtimeVersion.length() > 1) {
                runtimeVersion = DeployDumpHelper.getMajorMinorVersion(runtimeVersion);
            }
        }
        return runtimeVersion;
    }

    private static String getMajorMinorVersion(String runtimeVersion) {
        if (runtimeVersion == null) {
            return runtimeVersion;
        }
        int major = runtimeVersion.indexOf(46);
        int minor = -1;
        if (major != -1 && runtimeVersion.length() > major) {
            minor = runtimeVersion.substring(major + 1).indexOf(46);
        }
        if (minor == -1) {
            return runtimeVersion;
        }
        return runtimeVersion.substring(0, major + 1 + minor);
    }

    private static void transformOldProcessId(ApplicationProcessResource[] applicationProcesses) {
        for (ApplicationProcessResource process : applicationProcesses) {
            ApplicationProcessId processIdObj = new ApplicationProcessId(process.getProcessId());
            String newProcessId = processIdObj.getNewProcessId();
            process.setProcessId(newProcessId);
        }
    }

    private static void sortApplicationProcessesInChronologicalOrder(ApplicationProcessResource[] applicationProcesses) {
        Arrays.sort(applicationProcesses, new Comparator<ApplicationProcessResource>(){

            @Override
            public int compare(ApplicationProcessResource o1, ApplicationProcessResource o2) {
                if (o1.getLastStatusChange() < o2.getLastStatusChange()) {
                    return -1;
                }
                if (o1.getLastStatusChange() > o2.getLastStatusChange()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public static void printResultForRestartOperation(String operationName, Result result) {
        String resultMessage = result.getMessage();
        if (result.getCode() == 0) {
            DeployDumpHelper.dumpWithDateNewLine(operationName + " performed successfully.");
            System.out.println();
            StringBuilder message = new StringBuilder();
            DeployDumpHelper.addResultMessage(message, resultMessage);
            System.out.println(message);
        } else {
            DeployDumpHelper.dumpWithDateNewLine(operationName + FINISHED_WITH_ERROR);
            System.out.println();
        }
    }
}

