/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.util;

import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.commons.rest.entity.enumerations.VmSize;
import com.sap.core.deploy.commons.util.VmArgumentsUtil;
import com.sap.core.jpaasrepository.api.Descriptor;
import com.sap.core.jpaasrepository.api.ElasticityData;
import com.sap.jpaas.infrastructure.console.version.VersionUtilities;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DescriptorHelper {
    public static Descriptor createDescriptor(String updateSite, String iuName, String iuVersion, String componentURL, String[] jpaasServices, String severity, int min, int max, List<String> vmArguments, String serviceInstancesCfg, String jvmVersion, VmSize vmSize, String uploadConnections, String compression, String compressableMimeTypes, String compressionMinSize, String permStorageMode, int permStorageSize, String permStorageLocalPath, String uriEncoding, String maxThreads, String connectionTimeout, boolean delta, Map<String, String> metadataMap) {
        VmArgumentsUtil vmArgumentsUtil;
        String vmArgumentsString;
        Descriptor descriptor = Descriptor.createDescriptor((byte)3);
        descriptor.set("update_sites", updateSite);
        if (iuName != null) {
            descriptor.set("iu_name", iuName);
        }
        if (iuVersion != null) {
            descriptor.set("iu_version", iuVersion);
        }
        if (componentURL != null) {
            descriptor.set("url", componentURL);
        }
        if (jpaasServices != null) {
            HashSet services = new HashSet();
            Collections.addAll(services, jpaasServices);
            descriptor.setAs("jpaas_services", services);
        }
        if (severity != null) {
            descriptor.set("logSeverity", severity);
        }
        descriptor.setAs("elasticity.data", new ElasticityData(min, max));
        if (vmSize != null) {
            descriptor.set("vmSize", vmSize.name());
        }
        if (compression != null) {
            descriptor.set("compression", compression);
        }
        if (compressableMimeTypes != null) {
            descriptor.set("compressable_mime_type", compressableMimeTypes);
        }
        if (compressionMinSize != null) {
            descriptor.set("compression_min_size", compressionMinSize);
        }
        if (uriEncoding != null) {
            descriptor.set("URIEncoding", uriEncoding);
        }
        if (maxThreads != null) {
            descriptor.set("max_threads", maxThreads);
        }
        if (connectionTimeout != null) {
            descriptor.set("connection_timeout", connectionTimeout);
        }
        if (permStorageMode != null) {
            descriptor.set("perm_storage_mode", permStorageMode);
        }
        if (permStorageSize != 0) {
            descriptor.set("perm_storage_size", Integer.toString(permStorageSize));
        }
        if (permStorageLocalPath != null) {
            descriptor.set("perm_storage_local_path", permStorageLocalPath);
        }
        if (delta) {
            descriptor.set("delta", Boolean.TRUE.toString());
        }
        if (CheckHelper.isValueSpecified(vmArgumentsString = (vmArgumentsUtil = new VmArgumentsUtil()).processVmArguments(vmArguments))) {
            descriptor.set("vmArguments", vmArgumentsString);
        }
        if (CheckHelper.isValueSpecified(jvmVersion)) {
            descriptor.set("jvmVersion", jvmVersion.trim());
        }
        if (CheckHelper.isValueSpecified(serviceInstancesCfg)) {
            descriptor.set("services_instances_cfg", serviceInstancesCfg);
        }
        if (CheckHelper.isValueSpecified(uploadConnections)) {
            descriptor.set("connections", uploadConnections);
        }
        if (metadataMap != null && !metadataMap.isEmpty()) {
            descriptor.setAs("metadata", metadataMap);
        }
        return descriptor;
    }

    public static void setAppDomains(String[] appDomains, Descriptor descriptor) {
        if (appDomains != null) {
            HashSet domains = new HashSet();
            Collections.addAll(domains, appDomains);
            descriptor.setAs("network.visibility", domains);
        }
    }

    public static void setAppRuntimeId(String runtimeId, Descriptor descriptor) {
        if (runtimeId == null) {
            String sdkRuntimeId = VersionUtilities.getRuntime();
            if (!sdkRuntimeId.equals("unknown")) {
                descriptor.set("runtimeId", sdkRuntimeId);
            }
        } else {
            descriptor.set("runtimeId", runtimeId);
        }
    }

    public static void setAppRuntimeVersion(String runtimeVersion, Descriptor descriptor) {
        if (runtimeVersion != null) {
            descriptor.set("runtimeVersion", runtimeVersion);
        } else {
            String runtimeId = descriptor.get("runtimeId");
            int sdkMajorVersion = DescriptorHelper.getSDKMajorVersion();
            String sdkRuntimeId = VersionUtilities.getRuntime();
            if (DescriptorHelper.versionCouldBeDefaulted(runtimeId, sdkRuntimeId, sdkMajorVersion)) {
                descriptor.set("runtimeVersion", String.valueOf(sdkMajorVersion));
            }
        }
    }

    static boolean versionCouldBeDefaulted(String runtimeId, String sdkRuntimeId, int sdkMajorVersion) {
        if (sdkMajorVersion < 0) {
            return false;
        }
        if (runtimeId == null) {
            return true;
        }
        if ("ljs".equals(runtimeId) && DescriptorHelper.isSDKForLJS(sdkRuntimeId, sdkMajorVersion)) {
            return true;
        }
        return runtimeId.equalsIgnoreCase(sdkRuntimeId);
    }

    private static boolean isSDKForLJS(String sdkRuntimeId, int sdkMajorVersion) {
        return "unknown".equals(sdkRuntimeId) || "neo-java-web".equals(sdkRuntimeId) && sdkMajorVersion == 1 || "neo-javaee6-wp".equals(sdkRuntimeId) && sdkMajorVersion == 2;
    }

    public static int getSDKMajorVersion() {
        int res = -1;
        String sdkVersion = VersionUtilities.getRuntimeVersion();
        if (sdkVersion != null && !sdkVersion.isEmpty() && !sdkVersion.equals("unknown")) {
            try {
                res = Integer.parseInt(sdkVersion.split("\\.")[0]);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return -1;
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
        return res;
    }
}

