/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.util;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;

public class ExternalProcessExecutor {
    private DefaultExecutor executor = new DefaultExecutor();
    private Map executionEnvironment;

    public ExternalProcessExecutor(int timeout, File workDir, Map environment) {
        ExecuteWatchdog watchdog = new ExecuteWatchdog(timeout * 60 * 1000);
        this.executor.setWatchdog(watchdog);
        if (workDir != null) {
            this.executor.setWorkingDirectory(workDir);
        }
        PumpStreamHandler pumpHandler = new PumpStreamHandler(System.out, System.err);
        this.executor.setStreamHandler(pumpHandler);
        this.executionEnvironment = environment;
    }

    public int execute(CommandLine commandLine) throws IOException {
        return this.executor.execute(commandLine, this.executionEnvironment);
    }

    public boolean isFailure(int exitValue) {
        return this.executor.isFailure(exitValue);
    }
}

