/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.util;

import com.sap.core.deploy.client.Result;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.core.deploy.client.progress.IOperationNotification;
import com.sap.core.deploy.client.progress.IProgressListener;
import com.sap.core.deploy.client.progress.LifecycleOperationProperties;
import com.sap.core.deploy.client.progress.OperationProperties;
import com.sap.core.deploy.client.progress.OperationStatus;
import com.sap.core.deploy.client.progress.OperationType;

public class RollingUpdateProgressListener
implements IProgressListener {
    private static final String FINISHED_STATUS_MESSAGE = "Status %s reached after %d ms";
    private static final String WAITING_FOR_MESSAGE = "Waiting for %s status";
    private Status lastVMStatus = Status.UNKNOWN;

    @Override
    public void onOperationNotification(IOperationNotification notification) {
        OperationType operationType = notification.getOperationType();
        OperationStatus operationStatus = notification.getOperationStatus();
        OperationProperties operationProperties = notification.getOperationProperties();
        block0 : switch (operationStatus) {
            case STARTED: {
                switch (operationType) {
                    case WAIT: {
                        this.dumpWaitOperationStarted(operationProperties);
                        break block0;
                    }
                    case START: 
                    case STOP: {
                        this.dumpOperationStarted(operationType, operationProperties);
                        this.dumpWaitingForStatusStarted(operationType, operationProperties);
                        break block0;
                    }
                }
                this.dumpOperationStarted(operationType, operationProperties);
                break;
            }
            case RUNNING: {
                switch (operationType) {
                    case START: 
                    case STOP: {
                        LifecycleOperationProperties LifecycleOperationProperties2 = (LifecycleOperationProperties)operationProperties;
                        Status currentVMStatus = LifecycleOperationProperties2.getCurrentVMStatus();
                        Status wantedStatus = this.getWantedStatus(operationType);
                        if (!currentVMStatus.equals((Object)this.lastVMStatus) && !currentVMStatus.equals((Object)wantedStatus)) {
                            DeployDumpHelper.dumpWithDate(String.format(FINISHED_STATUS_MESSAGE, new Object[]{LifecycleOperationProperties2.getCurrentVMStatus(), operationProperties.getExecutionTime()}));
                            DeployDumpHelper.dumpWithDate(String.format(WAITING_FOR_MESSAGE, new Object[]{wantedStatus}));
                            this.lastVMStatus = currentVMStatus;
                            break block0;
                        }
                        DeployDumpHelper.dump(".");
                        break block0;
                    }
                }
                DeployDumpHelper.dump(".");
                break;
            }
            case FINISHED: {
                switch (operationType) {
                    case WAIT: {
                        DeployDumpHelper.dump(DeployDumpHelper.LINE_SEPARATOR);
                        break block0;
                    }
                    case START: 
                    case STOP: {
                        DeployDumpHelper.dumpWithDateNewLine(String.format(FINISHED_STATUS_MESSAGE, new Object[]{((LifecycleOperationProperties)operationProperties).getCurrentVMStatus(), operationProperties.getExecutionTime()}));
                        break block0;
                    }
                }
                this.dumpOperationFinished(operationType, operationProperties);
                break;
            }
            case FAILED: {
                this.dumpOperationFailed(operationType, operationProperties);
            }
        }
    }

    private void dumpWaitOperationStarted(OperationProperties operationProperties) {
        StringBuffer sb = new StringBuffer();
        sb.append("Wait");
        Long waitTime = operationProperties.getProperty("WAITING_TIME", Long.class);
        if (waitTime != null) {
            sb.append(" for ");
            sb.append(waitTime);
            sb.append(" seconds.");
        }
        DeployDumpHelper.dumpWithDate(sb);
    }

    private void dumpWaitingForStatusStarted(OperationType operationType, OperationProperties operationProperties) {
        LifecycleOperationProperties lifecycleOperationProperties = (LifecycleOperationProperties)operationProperties;
        Result operationResult = lifecycleOperationProperties.getOperationResult();
        if (0 == operationResult.getCode()) {
            DeployDumpHelper.dumpWithDate(String.format(WAITING_FOR_MESSAGE, new Object[]{this.getWantedStatus(operationType)}));
        }
        this.lastVMStatus = operationResult.getStatus();
    }

    private void dumpOperationStarted(OperationType operationType, OperationProperties operationProperties) {
        if (operationProperties instanceof LifecycleOperationProperties) {
            DeployDumpHelper.printResultForRestartOperation(this.capitalizeOperationTypeAsString(operationType) + " request", ((LifecycleOperationProperties)operationProperties).getOperationResult());
        } else {
            DeployDumpHelper.dumpWithDateNewLine(this.capitalizeOperationTypeAsString(operationType) + " request performed successfully.");
        }
    }

    private void dumpOperationFinished(OperationType operationType, OperationProperties operationProperties) {
        if (operationProperties instanceof LifecycleOperationProperties) {
            DeployDumpHelper.printResultForRestartOperation(this.capitalizeOperationTypeAsString(operationType) + " request", ((LifecycleOperationProperties)operationProperties).getOperationResult());
        } else {
            DeployDumpHelper.dumpWithDateNewLine(this.capitalizeOperationTypeAsString(operationType) + " request finished successfully.");
        }
    }

    private void dumpOperationFailed(OperationType operationType, OperationProperties operationProperties) {
        DeployDumpHelper.dumpWithDateNewLine(this.capitalizeOperationTypeAsString(operationType) + " request finished with error.");
    }

    private String capitalizeOperationTypeAsString(OperationType type) {
        StringBuffer sb = new StringBuffer();
        String typeAsString = type.toString().toLowerCase();
        sb.append(Character.toTitleCase(typeAsString.charAt(0)));
        sb.append(typeAsString.substring(1));
        return sb.toString();
    }

    private Status getWantedStatus(OperationType operationType) {
        Status wantedStatus = OperationType.START.equals((Object)operationType) ? Status.STARTED : Status.NOT_FOUND;
        return wantedStatus;
    }
}

