/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.util;

import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.core.deploy.client.cmd.util.DescriptorHelper;
import com.sap.core.deploy.client.cmd.util.RuntimeVersionsHelper;
import com.sap.core.deploy.commons.runtime.RuntimeVersions;
import com.sap.core.deploy.commons.runtime.Version;
import com.sap.jpaas.infrastructure.console.version.VersionUtilities;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class RuntimeVersionsDumpHelper {
    private static final DateFormat DF = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);

    public static void printRuntimeVersionsResult(String operationName, RuntimeVersionsHelper versionsHelper, boolean allVersions) {
        DeployDumpHelper.dumpWithNewLine(operationName);
        RuntimeVersionsDumpHelper.printSDKInUseInfo(versionsHelper);
        ConsoleOutputParameters outputParameters = RuntimeVersionsDumpHelper.determineConsoleOutputParameters(versionsHelper);
        if (RuntimeVersionsDumpHelper.shouldPrintAllRuntimes(versionsHelper.getUserProvidedRuntimeId(), allVersions) || !versionsHelper.isTheRequestForTheCurrentRuntime()) {
            RuntimeVersionsDumpHelper.printAllMajorVersionsRuntimeVersionsResult(versionsHelper, outputParameters);
        } else {
            RuntimeVersionsDumpHelper.printThisMajorVersionRuntimeVersionsResult(versionsHelper.getUserProvidedRuntimeId(), versionsHelper, outputParameters);
            if (allVersions) {
                RuntimeVersionsDumpHelper.printOtherMajorVersionsRuntimeVersionsResult(versionsHelper.getUserProvidedRuntimeId(), versionsHelper, outputParameters);
            }
        }
        System.out.println();
    }

    private static void printSDKInUseInfo(RuntimeVersionsHelper versionsHelper) {
        String runtimeVersion = VersionUtilities.getRuntimeVersion();
        if ("unknown".equals(runtimeVersion)) {
            return;
        }
        String runtimeId = "unknown".equals(VersionUtilities.getRuntime()) ? versionsHelper.getMappedSDKRuntimeId() : VersionUtilities.getRuntime();
        System.out.println("SDK in use: " + runtimeId + " " + RuntimeVersionsDumpHelper.getMajorAndMicroVersion(runtimeVersion));
    }

    private static ConsoleOutputParameters determineConsoleOutputParameters(RuntimeVersionsHelper versionsHelper) {
        int maxVersionLength = 0;
        int maxDescriptionLength = 0;
        Collection<RuntimeVersions> runtimes = versionsHelper.getRuntimes();
        for (RuntimeVersions rv : runtimes) {
            Collection<Version> versions = rv.getVersionResources();
            for (Version version : versions) {
                int descriptionLength;
                int versionLength = versionsHelper.getDisplayVersionString(rv.getRuntimeId(), version).length();
                if (versionLength > maxVersionLength) {
                    maxVersionLength = versionLength;
                }
                if ((descriptionLength = RuntimeVersionsDumpHelper.getVersionDescription(version).length()) <= maxDescriptionLength) continue;
                maxDescriptionLength = descriptionLength;
            }
        }
        return new ConsoleOutputParameters(maxVersionLength, maxDescriptionLength);
    }

    private static boolean shouldPrintAllRuntimes(String runtimeId, boolean allVersions) {
        return runtimeId == null && allVersions;
    }

    private static void printAllMajorVersionsRuntimeVersionsResult(RuntimeVersionsHelper versionsHelper, ConsoleOutputParameters outputParameters) {
        for (String runtimeId : versionsHelper.getRuntimesIds()) {
            Set<Integer> majorVersions = versionsHelper.getMajorVersions(runtimeId);
            for (int majorVersion : majorVersions) {
                System.out.println("------");
                System.out.println("SDK " + RuntimeVersionsDumpHelper.getRuntimeNameForPrinting(versionsHelper, runtimeId, majorVersion) + " " + majorVersion + ".x");
                RuntimeVersionsDumpHelper.printRuntimeVersionsResultForMajorVersion(runtimeId, versionsHelper, versionsHelper.getVersionsForMajorVersion(runtimeId, majorVersion), outputParameters);
            }
        }
    }

    private static String getRuntimeNameForPrinting(RuntimeVersionsHelper versionsHelper, String runtimeId, int majorVersion) {
        if ("ljs".equals(runtimeId)) {
            boolean JAVAWEB_VERSION = true;
            int JAVAEE6_VERSION = 2;
            if (majorVersion == 1) {
                return "neo-java-web";
            }
            if (majorVersion == 2) {
                return "neo-javaee6-wp";
            }
            throw new IllegalArgumentException("Cannot execute command for a non-existing runtime - there is no runtime with name ljs and major version " + majorVersion);
        }
        return runtimeId;
    }

    private static void printThisMajorVersionRuntimeVersionsResult(String runtimeId, RuntimeVersionsHelper versionsHelper, ConsoleOutputParameters outputParameters) {
        RuntimeVersionsDumpHelper.printRuntimeVersionsResultForMajorVersion(runtimeId, versionsHelper, versionsHelper.getVersionsForMajorVersion(runtimeId, DescriptorHelper.getSDKMajorVersion()), outputParameters);
    }

    private static void printOtherMajorVersionsRuntimeVersionsResult(String runtimeId, RuntimeVersionsHelper versionsHelper, ConsoleOutputParameters outputParameters) {
        int majorSdkVersion = DescriptorHelper.getSDKMajorVersion();
        ArrayList<Integer> otherMajorVersions = new ArrayList<Integer>(versionsHelper.getMajorVersions(runtimeId));
        otherMajorVersions.remove(new Integer(majorSdkVersion));
        if (otherMajorVersions.size() > 0) {
            System.out.println("------");
            System.out.println("Other SDKs supported by SAP Cloud Platform:");
            Iterator i$ = otherMajorVersions.iterator();
            while (i$.hasNext()) {
                int majorVersion = (Integer)i$.next();
                System.out.println("SDK " + majorVersion + ".x");
                RuntimeVersionsDumpHelper.printRuntimeVersionsResultForMajorVersion(runtimeId, versionsHelper, versionsHelper.getVersionsForMajorVersion(runtimeId, majorVersion), outputParameters);
            }
        }
    }

    private static void printRuntimeVersionsResultForMajorVersion(String runtimeId, RuntimeVersionsHelper versionsHelper, Collection<Version> versions, ConsoleOutputParameters outputParameters) {
        if (versions == null || versions.size() == 0) {
            System.out.println(" No available versions found");
            return;
        }
        ArrayList<Version> recommendedVersions = new ArrayList<Version>();
        ArrayList<Version> previousVersions = new ArrayList<Version>();
        for (Version version : versions) {
            if (version.isRecommended()) {
                recommendedVersions.add(version);
                continue;
            }
            previousVersions.add(version);
        }
        if (recommendedVersions.size() > 0) {
            if (previousVersions.size() > 0) {
                System.out.println(" Recommended:");
            }
            RuntimeVersionsDumpHelper.printRuntimeVersions(runtimeId, recommendedVersions, versionsHelper, outputParameters);
        }
        if (previousVersions.size() > 0) {
            System.out.println(" Previous (pinning apps to these is not recommended):");
            RuntimeVersionsDumpHelper.printRuntimeVersions(runtimeId, previousVersions, versionsHelper, outputParameters);
            System.out.println(" All earlier versions have expired. Pinning applications to these is not allowed.");
        }
    }

    private static void printRuntimeVersions(String runtimeId, Collection<Version> versions, RuntimeVersionsHelper versionsHelper, ConsoleOutputParameters outputParameters) {
        String versionColumnHead = "Version";
        String expirationColumnHead = "Valid until";
        String defalutSapJvmColumnHead = "Default SAP JVM Version";
        int maxVersionLength = outputParameters.maxVersionLength;
        int maxDescriptionLength = outputParameters.maxDescriptionLength;
        if (maxVersionLength + 1 + maxDescriptionLength < "Version".length()) {
            maxDescriptionLength = "Version".length() - maxVersionLength - 1;
        }
        char[] offsetChars = new char[maxVersionLength + 1 + maxDescriptionLength - "Version".length()];
        StringBuilder sb = new StringBuilder("   ").append("Version").append(offsetChars).append("  ").append("Valid until").append("  ").append("Default SAP JVM Version");
        System.out.println(sb);
        for (Version version : versions) {
            RuntimeVersionsDumpHelper.printRuntimeVersionResult(runtimeId, version, versionsHelper, maxVersionLength, maxDescriptionLength);
        }
    }

    private static void printRuntimeVersionResult(String runtimeId, Version version, RuntimeVersionsHelper versionsHelper, int maxVersionLength, int maxDescriptionLength) {
        String versionNumber = versionsHelper.getDisplayVersionString(runtimeId, version);
        String versionDescription = RuntimeVersionsDumpHelper.getVersionDescription(version);
        char[] versionOffsetChars = new char[maxVersionLength - versionNumber.length()];
        Arrays.fill(versionOffsetChars, ' ');
        char[] descriptionOffsetChars = new char[maxDescriptionLength - versionDescription.length()];
        Arrays.fill(descriptionOffsetChars, ' ');
        Calendar expDate = version.getExpirationDate();
        String expDateDescription = "<no end date available>";
        if (expDate != null) {
            expDateDescription = DF.format(expDate.getTime());
        }
        String defaultSapJvmVersion = version.getSapJvmVersions().get("default.jvm.version");
        StringBuilder sb = new StringBuilder("   ").append(versionNumber).append(' ').append(versionOffsetChars).append(versionDescription).append(descriptionOffsetChars).append("  ").append(expDateDescription).append("  ").append(defaultSapJvmVersion);
        System.out.println(sb.toString());
    }

    private static String getMajorAndMicroVersion(String fullVersion) {
        int firstDotIndex = fullVersion.indexOf(46);
        if (firstDotIndex == -1) {
            return fullVersion;
        }
        int secondDotIndex = fullVersion.indexOf(46, firstDotIndex + 1);
        if (secondDotIndex == -1) {
            return fullVersion;
        }
        return fullVersion.substring(0, secondDotIndex);
    }

    private static String getVersionDescription(Version version) {
        StringBuilder versionDescription = new StringBuilder();
        if (version.isBeta()) {
            versionDescription.append("(Beta)");
        }
        if (version.isDefault()) {
            if (versionDescription.length() > 0) {
                versionDescription.append(" ");
            }
            versionDescription.append("[default]");
        }
        return versionDescription.toString();
    }

    static class ConsoleOutputParameters {
        int maxVersionLength = 0;
        int maxDescriptionLength = 0;

        ConsoleOutputParameters(int maxVersionLength, int maxDescriptionLength) {
            this.maxVersionLength = maxVersionLength;
            this.maxDescriptionLength = maxDescriptionLength;
        }
    }
}

