/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.util;

import com.sap.core.deploy.client.DeployClient;
import com.sap.core.deploy.client.IConfigurationManager;
import com.sap.core.deploy.client.cmd.util.DescriptorHelper;
import com.sap.core.deploy.client.exceptions.DeployClientException;
import com.sap.core.deploy.commons.runtime.RuntimeVersions;
import com.sap.core.deploy.commons.runtime.Version;
import com.sap.core.deploy.commons.util.RuntimeVersionsComparator;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.version.VersionUtilities;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.http.client.HttpClient;

public class RuntimeVersionsHelper {
    private String userProvidedRuntimeId;
    private String mappedSDKRuntimeId;
    private Collection<RuntimeVersions> runtimes;
    private Set<String> runtimeIds;
    private Map<String, Map<Integer, Set<Version>>> byMajorVersion;
    private Map<String, Map<String, Set<Version>>> byMajorMinorVersion;
    private Map<String, Set<Integer>> majorVersions;

    public RuntimeVersionsHelper(HttpClient httpClient, String host, String runtimeId, boolean allVersions, String account) {
        this.userProvidedRuntimeId = runtimeId;
        this.mappedSDKRuntimeId = this.retrieveSDKRuntimeId();
        IConfigurationManager configManager = DeployClient.getConfigurationManager(httpClient, account);
        try {
            this.runtimes = this.userProvidedRuntimeId != null || allVersions ? configManager.listRuntimesAndVersions(this.userProvidedRuntimeId, allVersions, host) : configManager.listRuntimesAndVersions(this.mappedSDKRuntimeId, allVersions, host);
        }
        catch (DeployClientException e) {
            throw new CommandException("Runtime versions listing failed", e, 144);
        }
        this.createRuntimeVersionsIndices();
    }

    private String retrieveSDKRuntimeId() {
        if (!"unknown".equals(VersionUtilities.getRuntime())) {
            return VersionUtilities.getRuntime();
        }
        if (DescriptorHelper.getSDKMajorVersion() == 2) {
            return "neo-javaee6-wp";
        }
        return "neo-java-web";
    }

    private void createRuntimeVersionsIndices() {
        this.createRuntimeIdsList();
        this.groupMajorVersionsByRuntimeId();
        this.createIndexByMajorVersion();
        this.createIndexByMajorMicroVersion();
    }

    private void createRuntimeIdsList() {
        this.runtimeIds = new HashSet<String>();
        for (RuntimeVersions rv : this.runtimes) {
            String runtimeId = rv.getRuntimeId();
            this.runtimeIds.add(runtimeId);
        }
    }

    private void groupMajorVersionsByRuntimeId() {
        this.majorVersions = new HashMap<String, Set<Integer>>();
        for (RuntimeVersions rv : this.runtimes) {
            String runtimeName = rv.getRuntimeId();
            Collection<Version> versions = rv.getVersionResources();
            Set<Integer> majorVersionsForThisRuntime = this.majorVersions.get(runtimeName);
            if (majorVersionsForThisRuntime == null) {
                majorVersionsForThisRuntime = new HashSet<Integer>();
                this.majorVersions.put(runtimeName, majorVersionsForThisRuntime);
            }
            for (Version version : versions) {
                int thisMajorVersion = version.getMajor();
                majorVersionsForThisRuntime.add(thisMajorVersion);
            }
        }
    }

    private void createIndexByMajorVersion() {
        this.byMajorVersion = new HashMap<String, Map<Integer, Set<Version>>>();
        for (RuntimeVersions rv : this.runtimes) {
            String runtimeName = rv.getRuntimeId();
            Collection<Version> versions = rv.getVersionResources();
            Map<Integer, Set<Version>> versionsForThisRuntime = this.byMajorVersion.get(runtimeName);
            if (versionsForThisRuntime == null) {
                versionsForThisRuntime = new HashMap<Integer, Set<Version>>();
                this.byMajorVersion.put(runtimeName, versionsForThisRuntime);
            }
            for (Version version : versions) {
                int thisMajorVersion = version.getMajor();
                Set<Version> thisMajorVersionVersions = versionsForThisRuntime.get(thisMajorVersion);
                if (thisMajorVersionVersions == null) {
                    thisMajorVersionVersions = new TreeSet<Version>(new RuntimeVersionsComparator());
                    versionsForThisRuntime.put(thisMajorVersion, thisMajorVersionVersions);
                }
                thisMajorVersionVersions.add(version);
            }
        }
    }

    private void createIndexByMajorMicroVersion() {
        this.byMajorMinorVersion = new HashMap<String, Map<String, Set<Version>>>();
        for (RuntimeVersions rv : this.runtimes) {
            String runtimeName = rv.getRuntimeId();
            Collection<Version> versions = rv.getVersionResources();
            Map<String, Set<Version>> versionsForThisRuntime = this.byMajorMinorVersion.get(runtimeName);
            if (versionsForThisRuntime == null) {
                versionsForThisRuntime = new HashMap<String, Set<Version>>();
                this.byMajorMinorVersion.put(runtimeName, versionsForThisRuntime);
            }
            for (Version version : versions) {
                String thisMajorMinorVersion = version.getMajorMinorVersionString();
                Set<Version> thisMajorMinorVersionVersions = versionsForThisRuntime.get(thisMajorMinorVersion);
                if (thisMajorMinorVersionVersions == null) {
                    thisMajorMinorVersionVersions = new TreeSet<Version>(new RuntimeVersionsComparator());
                    versionsForThisRuntime.put(thisMajorMinorVersion, thisMajorMinorVersionVersions);
                }
                thisMajorMinorVersionVersions.add(version);
            }
        }
    }

    public String getUserProvidedRuntimeId() {
        return this.userProvidedRuntimeId;
    }

    public String getMappedSDKRuntimeId() {
        return this.mappedSDKRuntimeId;
    }

    public Collection<RuntimeVersions> getRuntimes() {
        return this.runtimes;
    }

    public Set<String> getRuntimesIds() {
        return this.runtimeIds;
    }

    public Set<Integer> getMajorVersions(String runtimeId) {
        if ("ljs".equals(runtimeId = this.resolveRuntimeId(runtimeId))) {
            HashSet<Integer> ljsMajorVersions = new HashSet<Integer>();
            for (Set<Integer> list : this.majorVersions.values()) {
                ljsMajorVersions.addAll(list);
            }
            return ljsMajorVersions;
        }
        return this.majorVersions.get(runtimeId);
    }

    public Set<Version> getVersionsForMajorVersion(String runtimeId, int majorVersion) {
        Map<Integer, Set<Version>> versionsGroupedByMajorVersion = this.byMajorVersion.get(runtimeId = this.resolveRuntimeId(runtimeId));
        if (versionsGroupedByMajorVersion != null) {
            return versionsGroupedByMajorVersion.get(majorVersion);
        }
        return null;
    }

    public Collection<Version> getAllVersionsForRuntimeId(String runtimeId) {
        runtimeId = this.resolveRuntimeId(runtimeId);
        for (RuntimeVersions rv : this.runtimes) {
            if (!rv.getRuntimeId().equals(runtimeId)) continue;
            return rv.getVersionResources();
        }
        throw new IllegalArgumentException("No versions found for runtime id " + runtimeId);
    }

    public String getDisplayVersionString(String runtimeId, Version version) {
        Set<Version> versions;
        runtimeId = this.resolveRuntimeId(runtimeId);
        String thisMajorMinorVersion = version.getMajorMinorVersionString();
        Map<String, Set<Version>> versionsGroupedByMajorMinorVersion = this.byMajorMinorVersion.get(runtimeId);
        if (versionsGroupedByMajorMinorVersion != null && (versions = versionsGroupedByMajorMinorVersion.get(thisMajorMinorVersion)) != null && versions.size() == 1) {
            return thisMajorMinorVersion;
        }
        return version.getVersionString();
    }

    public boolean isTheRequestForTheCurrentRuntime() {
        return this.userProvidedRuntimeId == null || this.mappedSDKRuntimeId.equals(this.userProvidedRuntimeId);
    }

    private String resolveRuntimeId(String runtimeId) {
        if (runtimeId == null) {
            return this.mappedSDKRuntimeId;
        }
        return runtimeId;
    }
}

