/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.util;

import com.sap.core.deploy.client.IDeployer;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.core.deploy.client.impl.OneByOneRestartStrategy;
import com.sap.core.deploy.commons.ApplicationProcessResource;
import com.sap.core.deploy.commons.retry.RetryPerformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class StopExtraProcessesUtil {
    private static final Logger LOGGER = Logger.getLogger(StopExtraProcessesUtil.class);
    protected static int GET_STATUS_WAIT_INTERVAL = 20000;
    protected RetryPerformer retryer = new RetryPerformer(OneByOneRestartStrategy.NETWORK_ISSUES_EXCEPTION_MESSAGES);
    private String application;
    private String component;
    private String host;
    private String tenant;

    public StopExtraProcessesUtil(String application, String component, String host, String tenant) {
        this.application = application;
        this.component = component;
        this.host = host;
        this.tenant = tenant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopExtraProcesses(IDeployer deployer, int desiredFinalProcessesCount) {
        boolean result = false;
        boolean shouldPrintCleanupMessages = false;
        try {
            StatusResult status = (StatusResult)this.retryer.retry(deployer, "getStatus", this.application, this.component, "0.0.0", this.host, this.tenant);
            ApplicationProcessResource[] applicationProcesses = status.getApplicationProcesses();
            int extraProcessesCount = applicationProcesses.length - desiredFinalProcessesCount;
            if (extraProcessesCount <= 0) {
                LOGGER.info("No extra processes to stop. Desired final processes count is: [" + desiredFinalProcessesCount + "] and the actual count is [" + applicationProcesses.length + "]");
                boolean bl = result = true;
                return bl;
            }
            shouldPrintCleanupMessages = true;
            DeployDumpHelper.dumpWithDateNewLine("Cleanup started...");
            DeployDumpHelper.dumpWithDate("Will try to stop " + extraProcessesCount + (extraProcessesCount == 1 ? "process" : "processes") + " because the application " + this.application + " is running with extra running processes");
            List<ApplicationProcessResource> notStartedProcesses = this.extractNotStartedProcesses(applicationProcesses);
            String logMessage = "Will stop process with id %s. Its state is %s.";
            boolean isStopOfNotStartedProcessesSuccessful = this.stopProcesses(this.retryer, deployer, notStartedProcesses.subList(0, Math.min(extraProcessesCount, notStartedProcesses.size())), logMessage + " It is not in started state");
            if (!isStopOfNotStartedProcessesSuccessful) {
                boolean bl = result = false;
                return bl;
            }
            status = (StatusResult)this.retryer.retry(deployer, "getStatus", this.application, this.component, "0.0.0", this.host, this.tenant);
            applicationProcesses = status.getApplicationProcesses();
            extraProcessesCount = applicationProcesses.length - desiredFinalProcessesCount;
            if (extraProcessesCount <= 0) {
                boolean bl = result = true;
                return bl;
            }
            notStartedProcesses = this.extractNotStartedProcesses(applicationProcesses);
            int startedProcessesCount = applicationProcesses.length - notStartedProcesses.size();
            Arrays.sort(applicationProcesses, new Comparator<ApplicationProcessResource>(){

                @Override
                public int compare(ApplicationProcessResource o1, ApplicationProcessResource o2) {
                    return (int)(o1.getLastStatusChange() - o2.getLastStatusChange());
                }
            });
            ArrayList<ApplicationProcessResource> oldestProcesses = new ArrayList<ApplicationProcessResource>();
            for (int i = 0; i < startedProcessesCount - desiredFinalProcessesCount; ++i) {
                oldestProcesses.add(applicationProcesses[i]);
            }
            result = this.stopProcesses(this.retryer, deployer, oldestProcesses, logMessage + " It is currently the oldest process.");
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Stopping extra processes failed.", e);
            result = false;
            return result;
        }
        finally {
            if (shouldPrintCleanupMessages) {
                if (result) {
                    DeployDumpHelper.dumpWithDateNewLine("Cleanup completed.");
                } else {
                    DeployDumpHelper.dumpWithDateNewLine("Cleanup failed! Could not stop extra processes that exceed the maximum allowed count of application processes! You may need to remove them manually.");
                }
            }
            return result;
        }
    }

    protected boolean stopProcesses(RetryPerformer retryer, IDeployer deployer, List<ApplicationProcessResource> applicationProcesses, String logMessage) throws Exception {
        for (int i = 0; i < applicationProcesses.size(); ++i) {
            DeployDumpHelper.dumpWithDate(String.format(logMessage, applicationProcesses.get(i).getProcessId(), applicationProcesses.get(i).getStatus()));
            retryer.retry(deployer, "stopProcess", this.application, this.component, applicationProcesses.get(i).getProcessId(), this.host);
        }
        return this.waitForStoppedProcess(retryer, deployer, applicationProcesses);
    }

    protected boolean waitForStoppedProcess(RetryPerformer retryer, IDeployer deployer, List<ApplicationProcessResource> processesToBeStopped) throws Exception {
        if (processesToBeStopped == null || processesToBeStopped.isEmpty()) {
            return true;
        }
        this.dumpProcessIds("Waiting for stop of " + (processesToBeStopped.size() == 1 ? "process" : "processes"), processesToBeStopped);
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)OneByOneRestartStrategy.START_STOP_TIMEOUT) {
            Thread.sleep(GET_STATUS_WAIT_INTERVAL);
            StatusResult status = (StatusResult)retryer.retry(deployer, "getStatus", this.application, this.component, "0.0.0", this.host, this.tenant);
            List<ApplicationProcessResource> applicationProcesses = Arrays.asList(status.getApplicationProcesses());
            Iterator<ApplicationProcessResource> iter = processesToBeStopped.iterator();
            while (iter.hasNext()) {
                if (applicationProcesses.contains(iter.next())) continue;
                iter.remove();
            }
            if (!processesToBeStopped.isEmpty()) continue;
            return true;
        }
        this.dumpProcessIds("Could not stop all of the not needed processes!", processesToBeStopped);
        return false;
    }

    protected void dumpProcessIds(String message, List<ApplicationProcessResource> notStartedProcesses) {
        StringBuilder sb = new StringBuilder(message);
        for (ApplicationProcessResource applicationProcess : notStartedProcesses) {
            sb.append(" ").append(applicationProcess.getProcessId());
        }
        DeployDumpHelper.dumpWithDate(sb.toString());
    }

    protected List<ApplicationProcessResource> extractNotStartedProcesses(ApplicationProcessResource[] applicationProcesses) {
        ArrayList<ApplicationProcessResource> notStartedProcesses = new ArrayList<ApplicationProcessResource>();
        for (ApplicationProcessResource applicationProcess : applicationProcesses) {
            LOGGER.info("application process " + applicationProcess.getProcessId() + " has status: " + applicationProcess.getStatus());
            if (Status.STARTED.name().equals(applicationProcess.getStatus())) continue;
            notStartedProcesses.add(applicationProcess);
        }
        return notStartedProcesses;
    }
}

