/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.validators;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.ParameterException;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.commons.validator.TomcatParamsValidator;

public class CompressionTypeValidator
implements IParameterValidator {
    @Override
    public void validate(String name, String value) throws ParameterException {
        if (!CheckHelper.isValueSpecified(value)) {
            throw new ParameterException("Parameter [" + name + "] has no value");
        }
        if (name.equals("--compressible-mime-type") && !TomcatParamsValidator.isCompressableMimeTypeValid(value)) {
            throw new ParameterException("Parameter [" + name + "] has invalid value [" + value + "]");
        }
        if (name.equals("--compression") && !TomcatParamsValidator.isCompressionValid(value)) {
            throw new ParameterException("Parameter [" + name + "] has invalid value [" + value + "]. Valid values are: 'on','off' or 'force'");
        }
        if (name.equals("--compression-min-size") && !TomcatParamsValidator.isPositiveNumber(value)) {
            throw new ParameterException("Parameter [" + name + "] has invalid value [" + value + "]");
        }
    }
}

