/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.validators;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.ParameterException;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.commons.validator.JVMVersionValidator;

public class JVMVersionParamValidator
implements IParameterValidator {
    @Override
    public void validate(String name, String value) throws ParameterException {
        if (!CheckHelper.isValueSpecified(value)) {
            throw new ParameterException("Parameter [" + name + "] has no value");
        }
        if ((name.equals("-j") || name.equals("--java-version")) && !JVMVersionValidator.isJvmVersionValid(value)) {
            StringBuilder sb = new StringBuilder("Parameter [" + name + "] has invalid value [" + value + "].\n");
            sb.append("Acceptable values: \n");
            sb.append("\t6\n");
            sb.append("\t7\n");
            sb.append("\t8\n");
            sb.append("\t1.3\n");
            sb.append("\t1.4\n");
            sb.append("\t1.5\n");
            sb.append("\t1.6\n");
            sb.append("\t1.7\n");
            sb.append("\t1.8");
            throw new ParameterException(sb.toString());
        }
    }
}

