/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.validators;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.ParameterException;
import java.util.regex.Pattern;

public class RuntimeIdValidator
implements IParameterValidator {
    private static final Pattern PATTERN_ALPHANUMERIC_LOWERCASE = Pattern.compile("^[a-z][a-z0-9\\-_]{0,29}$");

    @Override
    public void validate(String name, String value) throws ParameterException {
        if (value == null || !PATTERN_ALPHANUMERIC_LOWERCASE.matcher(value).matches()) {
            throw new ParameterException("Parameter " + name + " with value '" + value + "'" + " is not valid. It must be non-empty, lowercase letters, letters numbers or dashes, starting with a letter, limited to 30 characters.");
        }
    }
}

