/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.account.commands.subscriptions;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sap.core.account.commands.AbstractRemoteCommand;
import com.sap.core.account.commands.util.CommandTunnelRequestExecutor;
import com.sap.core.account.commands.util.DefaultResponseConsumingStrategy;
import com.sap.core.account.commands.util.HttpGetStrategy;
import com.sap.core.account.commands.util.HttpResponseContext;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.HttpEntity;

@Parameters(commandDescription="Lists the subscribed accounts for the given application")
public class ListSubscribedAccounts
extends AbstractRemoteCommand {
    @Parameter(names={"-a", "-account", "--account"}, description="Name of the account for which you provide user and password", validateWith=SACValidator.class)
    protected String account;
    @Parameter(names={"-b", "-application", "--application"}, description="Name of the application you want to manage, configure, or deploy", validateWith=SACValidator.class)
    private String application;
    static final String LIST_SUBSCRIBERS_COMMAND_NAME = "list-subscribed-accounts";

    @Override
    public void init() throws CommandException {
        CheckHelper.checkAccountAndAppSpecified((String)this.account, (String)this.application);
        super.init();
    }

    public void cleanup() throws CommandException {
    }

    public String getGroup() {
        return "subscriptions";
    }

    @Override
    public String getName() {
        return LIST_SUBSCRIBERS_COMMAND_NAME;
    }

    public void run() throws CommandException {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor(new HttpGetStrategy(), new ListSubscribers(), this, "application/" + this.application);
        helper.executeRequest();
    }

    @Override
    public String getAccount() {
        return this.account;
    }

    class ListSubscribers
    extends DefaultResponseConsumingStrategy {
        private ListSubscribers() {
        }

        @Override
        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 200) {
                HttpEntity entity = context.getResponse().getEntity();
                try {
                    JsonObject elements = (JsonObject)new JsonParser().parse((Reader)new InputStreamReader(entity.getContent(), "UTF-8"));
                    this.printResult((JsonArray)elements.get("subscribers"));
                }
                catch (Exception e) {
                    throw new CommandException(e);
                }
            } else if (context.getStatusCode() == 404) {
                String msg = "Application " + ListSubscribedAccounts.this.application + " for account " + ListSubscribedAccounts.this.getAccount() + " not found.";
                this.throwCommandExceptionWithContentInfoAndLog(msg, context);
            } else {
                super.consume(context);
            }
        }

        void printResult(JsonArray subscribers) {
            if (subscribers != null && subscribers.size() > 0) {
                System.out.println("Consumer Account");
                System.out.println("----------------");
                TreeMap<String, String> accounts = new TreeMap<String, String>();
                int maxWidth = 0;
                for (int i = 0; i < subscribers.size(); ++i) {
                    JsonObject subscriptionJson = (JsonObject)subscribers.get(i);
                    String accountName = subscriptionJson.get("consumer").getAsString();
                    JsonElement consumerDisplayName = subscriptionJson.get("consumerDisplayName");
                    String accountDisplayName = consumerDisplayName == null ? "" : consumerDisplayName.getAsString();
                    accounts.put(accountName, accountDisplayName);
                    maxWidth = Math.max(maxWidth, accountName.length());
                }
                for (Map.Entry entry : accounts.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (value.length() == 0) {
                        System.out.println(key);
                        continue;
                    }
                    System.out.print(key);
                    for (int i = key.length(); i < maxWidth + 3; ++i) {
                        System.out.print(" ");
                    }
                    System.out.println(value);
                }
            } else {
                System.out.println("No consumer accounts subscribed to application " + ListSubscribedAccounts.this.application + " in account " + ListSubscribedAccounts.this.getAccount() + ".");
            }
        }
    }
}

