/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.account.commands.subscriptions;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sap.core.account.commands.AbstractRemoteCommand;
import com.sap.core.account.commands.util.CommandTunnelRequestExecutor;
import com.sap.core.account.commands.util.DefaultResponseConsumingStrategy;
import com.sap.core.account.commands.util.HttpGetStrategy;
import com.sap.core.account.commands.util.HttpResponseContext;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.http.HttpEntity;

@Parameters(commandDescription="Lists the subscribed applications for the given account")
public class ListSubscribedApplications
extends AbstractRemoteCommand {
    @Parameter(names={"-a", "-account", "--account"}, description="Name of the account for which you provide user and password", validateWith=SACValidator.class)
    protected String account;
    static final String LIST_SUBSCRIPTIONS_COMMAND_NAME = "list-subscribed-applications";
    public static final String JSON_SUBSCRIPTIONS = "subscriptions";
    private static final String JSON_PROVIDER = "provider";
    private static final String JSON_APPLICATION = "application";

    @Override
    public void init() throws CommandException {
        CheckHelper.checkArgSpecified((String)"-a", (String)"--account", (String)this.getAccount());
        super.init();
    }

    public void cleanup() throws CommandException {
    }

    public String getGroup() {
        return JSON_SUBSCRIPTIONS;
    }

    @Override
    public String getName() {
        return LIST_SUBSCRIPTIONS_COMMAND_NAME;
    }

    public void run() throws CommandException {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor(new HttpGetStrategy(), new ListSubscriptionsConsumer(), this, "");
        helper.executeRequest();
    }

    @Override
    public String getAccount() {
        return this.account;
    }

    class ListSubscriptionsConsumer
    extends DefaultResponseConsumingStrategy {
        private ListSubscriptionsConsumer() {
        }

        @Override
        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 200) {
                HttpEntity entity = context.getResponse().getEntity();
                try {
                    JsonObject elements = (JsonObject)new JsonParser().parse((Reader)new InputStreamReader(entity.getContent(), "UTF-8"));
                    this.printResult((JsonArray)elements.get(ListSubscribedApplications.JSON_SUBSCRIPTIONS));
                }
                catch (Exception e) {
                    throw new CommandException(e);
                }
            } else if (context.getStatusCode() == 404) {
                String msg = "Account " + ListSubscribedApplications.this.getAccount() + " not found.";
                this.throwCommandExceptionWithContentInfoAndLog(msg, context);
            } else {
                super.consume(context);
            }
        }

        void printResult(JsonArray subscriptions) {
            if (subscriptions.size() > 0) {
                System.out.println("Application");
                System.out.println("-----------");
                for (int i = 0; i < subscriptions.size(); ++i) {
                    JsonObject subscriptionJson = (JsonObject)subscriptions.get(i);
                    System.out.println(subscriptionJson.get(ListSubscribedApplications.JSON_PROVIDER).getAsString() + ":" + subscriptionJson.get(ListSubscribedApplications.JSON_APPLICATION).getAsString());
                }
            } else {
                System.out.println("No subscriptions available.");
            }
        }
    }
}

