/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.account.commands.subscriptions;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.ParameterException;
import java.util.regex.Pattern;

public class ProviderApplicationValidator
implements IParameterValidator {
    private static final Pattern PATTERN_ALPHANUMERIC_LOWERCASE = Pattern.compile("^[a-z][a-z0-9]{0,29}$");

    public void validate(String name, String value) throws ParameterException {
        String[] values;
        if (value != null && (values = value.split(":")).length == 2 && PATTERN_ALPHANUMERIC_LOWERCASE.matcher(values[0]).matches() && PATTERN_ALPHANUMERIC_LOWERCASE.matcher(values[1]).matches()) {
            return;
        }
        throw new ParameterException("Parameter " + name + " with value '" + value + "'" + " is not valid. It must contain the provider account and the application name, separated by a colon (account:app). " + "Both account and application must be non-empty alphanumeric, lowercase letters, starting with a letter, limited to 30 characters.");
    }
}

