/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.account.commands.subscriptions;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.account.commands.AbstractRemoteCommand;
import com.sap.core.account.commands.subscriptions.ProviderApplicationValidator;
import com.sap.core.account.commands.util.CommandTunnelRequestExecutor;
import com.sap.core.account.commands.util.DefaultResponseConsumingStrategy;
import com.sap.core.account.commands.util.HttpPutStrategy;
import com.sap.core.account.commands.util.HttpResponseContext;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

@Parameters(commandDescription="Subscribes an application to the given account")
public class Subscribe
extends AbstractRemoteCommand {
    private static final String ERROR_MESSAGE_HEADER = "x-systemdb-errormsg";
    @Parameter(names={"-a", "-account", "--account"}, description="Name of the account for which you provide user and password", validateWith=SACValidator.class)
    private String account;
    @Parameter(names={"-b", "-application", "--application"}, description="Name of the application you want to manage, configure, or deploy", validateWith=ProviderApplicationValidator.class)
    private String application;
    private String provider;
    static final String SUBSCRIBE_COMMAND_NAME = "subscribe";

    @Override
    public void init() throws CommandException {
        CheckHelper.checkAccountAndAppSpecified((String)this.account, (String)this.application);
        if (this.application.contains(":")) {
            String[] array = this.application.split(":");
            this.provider = array[0];
            this.application = array[1];
        }
        super.init();
    }

    public void cleanup() throws CommandException {
    }

    public String getGroup() {
        return "subscriptions";
    }

    @Override
    public String getName() {
        return SUBSCRIBE_COMMAND_NAME;
    }

    public void run() throws CommandException {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor(new HttpPutStrategy(), new ListSubscribers(), this, "provider/" + this.provider + "/application/" + this.application);
        helper.executeRequest();
    }

    private static String getErrorMessageHeader(HttpResponse response) {
        Header header;
        if (response != null && (header = response.getFirstHeader(ERROR_MESSAGE_HEADER)) != null) {
            return header.getValue();
        }
        return null;
    }

    @Override
    public String getAccount() {
        return this.account;
    }

    class ListSubscribers
    extends DefaultResponseConsumingStrategy {
        private ListSubscribers() {
        }

        @Override
        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 201) {
                System.out.println("Account " + Subscribe.this.account + " subscribed to application " + Subscribe.this.provider + ":" + Subscribe.this.application + ".");
            } else if (context.getStatusCode() == 409) {
                String msg = "Account " + Subscribe.this.account + " already subscribed to application " + Subscribe.this.provider + ":" + Subscribe.this.application + ".";
                this.throwCommandExceptionWithContentInfoAndLog(msg, context);
            } else if (context.getStatusCode() == 404) {
                String msg = Subscribe.getErrorMessageHeader(context.getResponse());
                if (msg == null) {
                    msg = "Application " + Subscribe.this.application + " not found.";
                }
                this.throwCommandExceptionWithContentInfoAndLog(msg, context);
            } else {
                super.consume(context);
            }
        }
    }
}

