/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.account.commands.subscriptions;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.account.commands.AbstractRemoteCommand;
import com.sap.core.account.commands.subscriptions.ProviderApplicationValidator;
import com.sap.core.account.commands.util.CommandTunnelRequestExecutor;
import com.sap.core.account.commands.util.DefaultResponseConsumingStrategy;
import com.sap.core.account.commands.util.HttpDeleteStrategy;
import com.sap.core.account.commands.util.HttpResponseContext;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;

@Parameters(commandDescription="Unsubscribes an application from the given account")
public class Unsubscribe
extends AbstractRemoteCommand {
    @Parameter(names={"-a", "-account", "--account"}, description="Name of the account for which you provide user and password", validateWith=SACValidator.class)
    private String account;
    @Parameter(names={"-b", "-application", "--application"}, description="Name of the application you want to manage, configure, or deploy", validateWith=ProviderApplicationValidator.class)
    private String application;
    private String provider;
    static final String UNSUBSCRIBE_COMMAND_NAME = "unsubscribe";

    @Override
    public void init() throws CommandException {
        if (this.application != null && this.application.contains(":")) {
            String[] array = this.application.split(":");
            this.provider = array[0];
            this.application = array[1];
        }
        CheckHelper.checkAccountAndAppSpecified((String)this.account, (String)this.application);
        super.init();
    }

    public void cleanup() throws CommandException {
    }

    public String getGroup() {
        return "subscriptions";
    }

    @Override
    public String getName() {
        return UNSUBSCRIBE_COMMAND_NAME;
    }

    public void run() throws CommandException {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor(new HttpDeleteStrategy(), new ListSubscribers(), this, "provider/" + this.provider + "/application/" + this.application);
        helper.executeRequest();
    }

    @Override
    public String getAccount() {
        return this.account;
    }

    class ListSubscribers
    extends DefaultResponseConsumingStrategy {
        private ListSubscribers() {
        }

        @Override
        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 204) {
                System.out.println("Subscription for application " + Unsubscribe.this.provider + ":" + Unsubscribe.this.application + " deleted from account " + Unsubscribe.this.account + ".");
            } else if (context.getStatusCode() == 404) {
                String msg = "Account " + Unsubscribe.this.account + " cannot be unsubscribed from application " + Unsubscribe.this.provider + ":" + Unsubscribe.this.application + ". Check if the correct account name and application name were provided.";
                this.throwCommandExceptionWithContentInfoAndLog(msg, context);
            } else {
                super.consume(context);
            }
        }
    }
}

