/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.account.commands.util;

import com.sap.core.account.commands.util.HttpClientProvider;
import com.sap.core.account.commands.util.HttpResponseConsumingStrategy;
import com.sap.core.account.commands.util.HttpResponseContext;
import com.sap.core.account.commands.util.HttpUriRequestStrategy;
import com.sap.core.account.commands.util.ICommandTunnelCommand;
import com.sap.core.utils.infrastructure.validation.HostValidationException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.log4j.Logger;

public class CommandTunnelRequestExecutor {
    private final Logger LOGGER = Logger.getLogger(CommandTunnelRequestExecutor.class);
    public static final int EXIT_CODE_ANY_PROBLEM = 255;
    private final ICommandTunnelCommand command;
    private final String psaApi;
    private final HttpResponseConsumingStrategy responseConsumerStrategy;
    private final HttpUriRequestStrategy httpUriRequestStrategy;

    public CommandTunnelRequestExecutor(HttpUriRequestStrategy restCallStrategy, HttpResponseConsumingStrategy httpUriRequestStrategy, ICommandTunnelCommand command, String psaApiPath) {
        this.httpUriRequestStrategy = restCallStrategy;
        this.responseConsumerStrategy = httpUriRequestStrategy;
        this.psaApi = psaApiPath;
        this.command = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeRequest() throws CommandException {
        System.out.println("");
        HttpClient httpClient = null;
        try {
            HttpResponse response;
            httpClient = this.getClientWithBasicAuth();
            HttpUriRequest httpUriRequest = this.httpUriRequestStrategy.getHttpUriRequest(this.getRequestUri());
            try {
                response = httpClient.execute(httpUriRequest);
            }
            catch (UnknownHostException e) {
                throw new CommandException((Throwable)new UnknownHostException(httpUriRequest.getURI().toString()), 255);
            }
            if (response == null) {
                this.LOGGER.error((Object)("Internal error: Response of " + httpUriRequest.toString() + " is empty."));
                throw new CommandException("Failed due to an internal error", 255);
            }
            if (response.getStatusLine() == null) {
                this.LOGGER.error((Object)(" Internal error: Response StatusLine of " + httpUriRequest.toString() + " empty."));
                throw new CommandException("Failed due to internal error", 255);
            }
            this.responseConsumerStrategy.consume(new HttpResponseContext(response, httpUriRequest, this.command));
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            this.wrappAndThrowCommandException("Unexpected exception occurred", e, 255);
        }
        finally {
            if (httpClient != null && httpClient.getConnectionManager() != null) {
                httpClient.getConnectionManager().shutdown();
            }
        }
    }

    String getRequestUri() {
        String serviceName = this.command.getServiceName();
        if (serviceName == null || serviceName.length() == 0) {
            serviceName = "subscriptions";
        }
        String serviceUriPath = "/services/v1/instances/" + this.command.getAccount() + "/" + serviceName + "/" + "v1" + "/" + this.psaApi;
        return CommandTunnelRequestExecutor.getRequestUri(this.command.getHost(), serviceUriPath);
    }

    static String getRequestUri(String host, String serviceUriPath) {
        String result = CommandTunnelRequestExecutor.getCommandTunnelHost(host);
        result = serviceUriPath.startsWith("/") ? result + serviceUriPath.substring(1) : result + serviceUriPath;
        return result;
    }

    static String getCommandTunnelHost(String host) {
        host = host.toLowerCase();
        String currentHttpsPrefix = null;
        if (host.startsWith("https://")) {
            currentHttpsPrefix = "https://";
        } else if (host.startsWith("http://")) {
            currentHttpsPrefix = "http://";
        } else {
            throw new CommandException("Host '" + host + "' does not start with '" + "https://" + "' or with '" + "http://" + "'.", 255);
        }
        String result = null;
        result = !host.startsWith("https://services") ? currentHttpsPrefix + "services." + host.substring(currentHttpsPrefix.length()) : host;
        if (!result.endsWith("/")) {
            result = result + "/";
        }
        return result;
    }

    HttpClient getClientWithBasicAuth() throws URISyntaxException, IOException {
        try {
            return HttpClientProvider.createClientWithBasicAuth(this.command.getUser(), this.command.getPassword(), this.getRequestUri());
        }
        catch (HostValidationException e) {
            throw new ClientProtocolException("Host validation failed", (Throwable)e);
        }
    }

    private void wrappAndThrowCommandException(String newMsg, Exception cause, int exitCode) {
        throw new CommandException(newMsg, (Throwable)new Exception(newMsg, cause), exitCode);
    }
}

