/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.account.commands.util;

import com.sap.core.account.commands.util.HttpResponseConsumingStrategy;
import com.sap.core.account.commands.util.HttpResponseContext;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import org.apache.log4j.Logger;

public abstract class DefaultResponseConsumingStrategy
implements HttpResponseConsumingStrategy {
    private final Logger LOGGER = Logger.getLogger(DefaultResponseConsumingStrategy.class);

    @Override
    public void consume(HttpResponseContext context) throws CommandException {
        String msg;
        switch (context.getStatusCode()) {
            case 401: {
                msg = "The identity of user " + context.getCommand().getUser() + " could not be verified.\n" + "Please verify the supplied user name and password and execute the command again.";
                break;
            }
            case 500: {
                msg = "An internal server error occurred.";
                break;
            }
            case 503: {
                msg = "The server " + context.getHttpUriRequest().getURI().toString() + " is unavailable.";
                break;
            }
            case 403: {
                msg = "Authorization error - the execution was rejected.";
                break;
            }
            case 408: 
            case 504: {
                msg = "Request timeout for " + context.getHttpUriRequest().getURI().toString() + ".";
                break;
            }
            default: {
                msg = "An unexpected internal problem occurred.\n";
            }
        }
        this.throwCommandExceptionWithContentInfoAndLog(msg, context);
    }

    public void throwCommandExceptionWithContentInfoAndLog(String detailMsg, HttpResponseContext context) {
        this.throwCommandExceptionWithContentInfoAndLog(detailMsg, null, context);
    }

    public void throwCommandExceptionWithContentInfoAndLog(String detailMsg, String additionalLogMessage, HttpResponseContext context) {
        String responseContentString;
        this.logResponseContent(detailMsg, additionalLogMessage, context);
        String exceptionMsg = detailMsg + "\n";
        if ("text/plain".equals(context.getResponseContentTypeValue()) && (responseContentString = context.getResponseContentString()) != null) {
            exceptionMsg = exceptionMsg + "\n" + responseContentString;
        }
        throw new CommandException(exceptionMsg, 255);
    }

    private void logResponseContent(String detailedMsg, String additionalLogMessage, HttpResponseContext context) {
        this.LOGGER.error((Object)detailedMsg);
        if (additionalLogMessage != null) {
            this.LOGGER.error((Object)additionalLogMessage);
        }
        this.LOGGER.error((Object)("request URI: " + context.getHttpUriRequest().getURI().toString()));
        this.LOGGER.error((Object)("statusCode: " + context.getStatusCode() + " " + this.getStatusCodeDetailMsg(context)));
        this.LOGGER.error((Object)("contentType: " + context.getResponseContentTypeValue()));
        this.LOGGER.error((Object)("content: " + context.getResponseContentString()));
    }

    private String getStatusCodeDetailMsg(HttpResponseContext context) {
        if (context.getStatusCode() == 400) {
            return "SC_BAD_REQUEST";
        }
        if (context.getStatusCode() == 502) {
            return "SC_BAD_GATEWAY";
        }
        if (context.getStatusCode() == 403) {
            return "SC_FORBIDDEN";
        }
        if (context.getStatusCode() == 404) {
            return "SC_NOT_FOUND";
        }
        if (context.getStatusCode() == 404) {
            return "SC_NOT_FOUND";
        }
        if (context.getStatusCode() == 500) {
            return "SC_INTERNAL_SERVER_ERROR";
        }
        if (context.getStatusCode() == 503) {
            return "SC_SERVICE_UNAVAILABLE";
        }
        if (context.getStatusCode() == 504) {
            return "SC_GATEWAY_TIMEOUT";
        }
        return "";
    }
}

