/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.account.commands.util;

import com.sap.core.utils.infrastructure.validation.AuthenticationException;
import com.sap.core.utils.infrastructure.validation.HostValidationException;
import com.sap.core.utils.infrastructure.validation.LandscapeHostValidator;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.client.HttpClient;

public class HttpClientProvider {
    private static HttpClientProvider instance;

    private static HttpClientProvider getInstance() {
        if (instance == null) {
            instance = new HttpClientProvider();
        }
        return instance;
    }

    public static HttpClient createClientWithBasicAuth(String username, String password, String url) throws MalformedURLException, HostValidationException {
        return HttpClientProvider.getInstance().createClientWithBasicAuthentication(username, password, url);
    }

    protected HttpClient createClientWithBasicAuthentication(String username, String password, String url) throws MalformedURLException, HostValidationException {
        return HttpClientProvider.createClientWithBasicAuth(username, password, url, 20000);
    }

    public static HttpClient createClientWithBasicAuth(String username, String password, String url, int socketTimeout) throws MalformedURLException, ValidationException {
        return HttpClientProvider.getInstance().createClientWithBasicAuthentication(username, password, url, socketTimeout);
    }

    protected HttpClient createClientWithBasicAuthentication(String username, String password, String url, int socketTimeout) throws MalformedURLException, ValidationException {
        try {
            return LandscapeHostValidator.getHttpClient((URL)new URL(url), (String)"/", (int)socketTimeout, (String)username, (String)password, (boolean)true);
        }
        catch (HostValidationException e) {
            throw new ValidationException((Throwable)e, 41);
        }
        catch (AuthenticationException e) {
            throw new ValidationException((Throwable)e, 110);
        }
        catch (IOException e) {
            throw new ValidationException((Throwable)e, 1);
        }
    }
}

