/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.account.commands.util;

import com.google.gson.JsonObject;
import com.sap.core.account.commands.util.HttpResponseContext;
import com.sap.core.account.commands.util.HttpUriRequestStrategy;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;

public class HttpPutStrategy
implements HttpUriRequestStrategy {
    private final Logger LOGGER = Logger.getLogger(HttpResponseContext.class);
    public static final String MIME_TYPE_APPLICATION_JSON = "application/json";
    public Entity entity;

    public static Entity createJsonPropertyEntity(String key, String value) {
        return new Entity(HttpPutStrategy.getAsJsonString(key, value), MIME_TYPE_APPLICATION_JSON, null);
    }

    private static String getAsJsonString(String key, String value) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(key, value);
        String string = jsonObject.toString();
        return string;
    }

    public HttpPutStrategy(Entity entity) {
        this.entity = entity;
    }

    public HttpPutStrategy() {
        this(null);
    }

    @Override
    public HttpUriRequest getHttpUriRequest(String uri) throws UnsupportedEncodingException {
        HttpPut httpPut = new HttpPut(uri);
        if (this.entity != null && this.entity.entityString != null) {
            this.LOGGER.info((Object)("Put with " + this.entity.toString()));
            httpPut.setEntity((HttpEntity)new StringEntity(this.entity.entityString, this.entity.entityMimeType, this.entity.entityCharset));
        }
        return httpPut;
    }

    public static class Entity {
        private final String entityString;
        private final String entityMimeType;
        private final String entityCharset;

        public Entity(String entityString, String entityMimeType, String entityCharset) {
            this.entityString = entityString;
            this.entityMimeType = entityMimeType;
            this.entityCharset = entityCharset;
        }

        public String toString() {
            String result = "Entity(";
            if (this.entityMimeType != null) {
                result = result + "mimeType= '" + this.entityMimeType + "' ";
            }
            if (this.entityString != null) {
                result = result + "entityString= '" + this.entityString + "' ";
            }
            result = result + ")";
            return result;
        }
    }
}

