/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.account.commands.util;

import com.sap.core.account.commands.util.ICommandTunnelCommand;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.log4j.Logger;

public class HttpResponseContext {
    private final HttpResponse response;
    private final HttpUriRequest httpUriRequest;
    private final ICommandTunnelCommand command;
    private boolean contentTypeSet = false;
    private String contentTypeValue = null;
    private boolean contentStringSet = false;
    private String contentString;
    private final Logger LOGGER = Logger.getLogger(HttpResponseContext.class);

    public HttpResponseContext(HttpResponse response, HttpUriRequest httpUriRequest, ICommandTunnelCommand command) {
        this.response = response;
        this.httpUriRequest = httpUriRequest;
        this.command = command;
    }

    public ICommandTunnelCommand getCommand() {
        return this.command;
    }

    private String getContentTypeValue() {
        return this.contentTypeValue;
    }

    private void setContentTypeValue(String contentTypeValue) {
        this.contentTypeSet = true;
        this.contentTypeValue = contentTypeValue;
    }

    private String getContentString() {
        return this.contentString;
    }

    private void setContentString(String contentString) {
        this.contentStringSet = true;
        this.contentString = contentString;
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public HttpUriRequest getHttpUriRequest() {
        return this.httpUriRequest;
    }

    public String getResponseContentTypeValue() {
        if (!this.contentTypeSet) {
            this.setContentTypeValue(this.readContentTypeValue());
        }
        return this.getContentTypeValue();
    }

    private String readContentTypeValue() {
        if (this.response == null || this.response.getEntity() == null) {
            return null;
        }
        Header contentType = this.response.getEntity().getContentType();
        if (contentType == null) {
            return null;
        }
        return contentType.getValue();
    }

    public String getResponseContentString() {
        if (!this.contentStringSet) {
            this.setContentString(this.readContentString());
        }
        return this.getContentString();
    }

    private String readContentString() {
        if (this.response == null || this.response.getEntity() == null) {
            return null;
        }
        try {
            String contendString;
            if (this.response.getEntity().getContentLength() == 0L) {
                return null;
            }
            InputStream contentInputStream = this.response.getEntity().getContent();
            String encoding = null;
            if (this.response.getEntity().getContentEncoding() != null) {
                encoding = this.response.getEntity().getContentEncoding().getValue();
            }
            if ((contendString = IOUtils.toString((InputStream)contentInputStream, (String)(encoding = encoding == null ? "UTF-8" : encoding))) != null && contendString.trim().length() == 0) {
                contendString = null;
            }
            return contendString;
        }
        catch (Exception e) {
            this.LOGGER.error((Object)("An unexpected exception occurred while reading httpResponse.getEntity().getContent() for " + this.httpUriRequest.toString() + "."), (Throwable)e);
            return null;
        }
    }
}

