/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.service.auditlog.impl;

import com.sap.cloud.auditlog.AuditLogMessage;
import com.sap.cloud.auditlog.AuditLogMessageFactory;
import com.sap.cloud.auditlog.AuditedDataSubject;
import com.sap.cloud.auditlog.AuditedObject;
import com.sap.cloud.auditlog.ConfigurationChangeAuditMessage;
import com.sap.cloud.auditlog.DataModificationAuditMessage;
import com.sap.cloud.auditlog.ReadAccessAuditMessage;
import com.sap.cloud.auditlog.SecurityEventAuditMessage;
import com.sap.cloud.auditlog.exception.NotSupportedMessageTypeException;
import com.sap.core.service.auditlog.impl.AuditLogMessageImpl;
import com.sap.core.service.auditlog.impl.AuditedDataSubjectImpl;
import com.sap.core.service.auditlog.impl.AuditedObjectImpl;
import com.sap.core.service.auditlog.mbean.ClientStatusMBeanImpl;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogMessageFactoryImpl
implements AuditLogMessageFactory {
    private static Logger LOGGER = LoggerFactory.getLogger(AuditLogMessageFactoryImpl.class);
    public static final String AUDITLOG_MBEAN_NAME = "com.sap.cloud.auditlog:name=AuditLogClientStatus,type=AuditLogClientStatus";

    static {
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName(AUDITLOG_MBEAN_NAME);
            ClientStatusMBeanImpl mBean = new ClientStatusMBeanImpl();
            platformMBeanServer.registerMBean(mBean, objectName);
        }
        catch (InstanceAlreadyExistsException exc) {
            LOGGER.info("MBean com.sap.cloud.auditlog:name=AuditLogClientStatus,type=AuditLogClientStatus is already registered.", (Throwable)exc);
        }
        catch (Exception e) {
            LOGGER.error("Unable to create/register auditlog clien check Mbean: ", (Throwable)e);
        }
    }

    public <T extends AuditLogMessage> T createAuditLogMessage(Class<T> clazz) throws NotSupportedMessageTypeException {
        if (ConfigurationChangeAuditMessage.class.equals(clazz)) {
            AuditLogMessageImpl message = new AuditLogMessageImpl();
            message.addSubCategory("configuration");
            return (T)message;
        }
        if (ReadAccessAuditMessage.class.equals(clazz)) {
            AuditLogMessageImpl message = new AuditLogMessageImpl();
            message.addSubCategory("data-access");
            return (T)message;
        }
        if (DataModificationAuditMessage.class.equals(clazz)) {
            AuditLogMessageImpl message = new AuditLogMessageImpl();
            message.addSubCategory("data-modification");
            return (T)message;
        }
        if (SecurityEventAuditMessage.class.equals(clazz)) {
            AuditLogMessageImpl message = new AuditLogMessageImpl();
            message.addSubCategory("security-events");
            return (T)message;
        }
        if (AuditLogMessage.class.equals(clazz)) {
            AuditLogMessageImpl message = new AuditLogMessageImpl();
            return (T)message;
        }
        throw new NotSupportedMessageTypeException();
    }

    public AuditedObject createAuditedObject() {
        return new AuditedObjectImpl();
    }

    public AuditedDataSubject createAuditedDataSubject() {
        return new AuditedDataSubjectImpl();
    }
}

