/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.service.auditlog.impl;

import com.sap.cloud.auditlog.AuditLogMessage;
import com.sap.cloud.auditlog.AuditedDataSubject;
import com.sap.cloud.auditlog.AuditedObject;
import com.sap.cloud.auditlog.ConfigurationChangeAuditMessage;
import com.sap.cloud.auditlog.DataModificationAuditMessage;
import com.sap.cloud.auditlog.ReadAccessAuditMessage;
import com.sap.cloud.auditlog.SecurityEventAuditMessage;
import com.sap.cloud.auditlog.exception.AuditLogWriteException;
import com.sap.cloud.auditlog.exception.ValidationError;
import com.sap.core.service.auditlog.impl.AuditedObjectImpl;
import com.sap.core.service.auditlog.impl.CommunicationUtils;
import com.sap.core.service.auditlog.impl.FieldsProviderUtility;
import com.sap.core.service.auditlog.impl.Utils;
import com.sap.core.service.auditlog.message.MessageCustom;
import com.sap.core.service.auditlog.message.MessageObject;
import com.sap.core.service.auditlog.message.MessageVerb;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogMessageImpl
implements AuditLogMessage,
ConfigurationChangeAuditMessage,
SecurityEventAuditMessage,
DataModificationAuditMessage,
ReadAccessAuditMessage {
    protected static final String PAIR_SEPARATOR = ",";
    protected static final String KEY_VALUE_SEPARATOR = "=";
    private static final String OBJECT = "object";
    private static final String VERB = "verb";
    private static final String CUSTOM = "custom";
    private MessageVerb messageVerb = null;
    private MessageObject messageObject = null;
    private MessageCustom messageCustom = null;
    protected String category = "audit";
    private String loggedByClassName = null;
    protected Object messageId;
    private static Logger logger = LoggerFactory.getLogger(AuditLogMessageImpl.class);
    public static final String AUDIT_LOG_FORMAT_VERSION = "2";
    private CommunicationUtils communicationUtils;

    public void setObjectId(String objectId) {
        if (this.messageObject == null) {
            this.messageObject = new MessageObject();
        }
        AuditedObjectImpl auditedObject = new AuditedObjectImpl();
        auditedObject.setType("Legacy.Object");
        auditedObject.addIdentifier("key", Utils.encodeString(objectId));
        this.messageObject.addAuditedObject(auditedObject);
    }

    public void setObjectName(String objectName) {
        if (this.messageObject == null) {
            this.messageObject = new MessageObject();
        }
        this.messageObject.setObjectName(Utils.encodeString(objectName));
    }

    public void addObjectAttribute(String objectAttribName, String objectAttribValue) {
        if (this.messageObject == null) {
            this.messageObject = new MessageObject();
        }
        this.messageObject.addObjectAttribute(Utils.encodeString(objectAttribName), Utils.encodeString(objectAttribValue));
    }

    public void addCustomAttribute(String customAttribName, String customAttribValue) {
        if (this.messageCustom == null) {
            this.messageCustom = new MessageCustom();
        }
        this.messageCustom.addCustomParam(Utils.encodeString(customAttribName), Utils.encodeString(customAttribValue));
    }

    public void addChangedValues(String attributeName, String oldValue, String newValue) {
        if (this.messageObject == null) {
            this.messageObject = new MessageObject();
        }
        this.messageObject.addObjectAttributeChange(Utils.encodeString(attributeName), Utils.encodeString(oldValue), Utils.encodeString(newValue));
    }

    public void configurationChanged(String objectId, String objectName, String attributName, String oldValue, String newValue) {
        this.setAction(ConfigurationChangeAuditMessage.BasicActions.UPDATE);
        this.setObjectId(objectId);
        this.setObjectName(objectName);
        this.addChangedValues(attributName, oldValue, newValue);
    }

    public void configurationCreated(String objectId) {
        this.setAction(ConfigurationChangeAuditMessage.BasicActions.CREATE);
        this.setObjectId(objectId);
    }

    public void configurationDeleted(String objectId) {
        this.setAction(ConfigurationChangeAuditMessage.BasicActions.DELETE);
        this.setObjectId(objectId);
    }

    public void setReadAttributeAttempt(String objectId, String objectName, String attributeName) {
        this.setAction("read-attempt");
        this.setObjectId(objectId);
        this.setObjectName(objectName);
        if (this.messageObject == null) {
            this.messageObject = new MessageObject();
        }
        this.messageObject.addObjectAttribute(Utils.encodeString(attributeName), "%void");
    }

    public void setReadAttribute(String objectId, String objectName, String attributeName) {
        this.setAction("read");
        this.setObjectId(objectId);
        this.setObjectName(objectName);
        if (this.messageObject == null) {
            this.messageObject = new MessageObject();
        }
        this.messageObject.addObjectAttribute(Utils.encodeString(attributeName), "%void");
    }

    public void setReadAttribute(String objectId, String objectName, String attributeName, String Attributevalue) {
        this.setAction("read");
        this.setObjectId(objectId);
        this.setObjectName(objectName);
        this.addObjectAttribute(attributeName, Attributevalue);
    }

    public void setAction(ConfigurationChangeAuditMessage.BasicActions action, long timestamp) {
        this.setAction(action);
        this.setTimestamp(timestamp);
    }

    public void setAction(ConfigurationChangeAuditMessage.BasicActions action) {
        this.setAction(action.toString());
    }

    public void setAction(String action) {
        if (this.messageVerb == null) {
            this.messageVerb = new MessageVerb();
        }
        this.messageVerb.setAction(Utils.encodeString(action));
    }

    public void setAction(DataModificationAuditMessage.BasicActions action, long timestamp) {
        this.setAction(action);
        this.setTimestamp(timestamp);
    }

    public void setAction(DataModificationAuditMessage.BasicActions action) {
        this.setAction(action.toString());
    }

    public void setTimestamp(long timestamp) {
        if (this.messageVerb == null) {
            this.messageVerb = new MessageVerb();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String timeStr = simpleDateFormat.format(new Date(timestamp));
        this.messageVerb.setTimestamp(timeStr);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean addPairSeparator = false;
        addPairSeparator = Utils.writeMessagePart(builder, addPairSeparator, this.messageVerb, VERB);
        addPairSeparator = Utils.writeMessagePart(builder, addPairSeparator, this.messageObject, OBJECT);
        addPairSeparator = Utils.writeMessagePart(builder, addPairSeparator, this.messageCustom, CUSTOM);
        return builder.toString();
    }

    public void setReadAttribute(String objectId, String objectName, String attributeName, byte[] attributeValue) throws UnsupportedEncodingException {
        this.setReadAttribute(objectId, objectName, attributeName, Utils.encodeBinary(attributeValue));
    }

    public void configurationChanged(String objectId, String objectName, String attributName, byte[] oldValue, byte[] newValue) throws UnsupportedEncodingException {
        this.configurationChanged(objectId, objectName, attributName, Utils.encodeBinary(oldValue), Utils.encodeBinary(newValue));
    }

    public void addChangedValues(String attributeName, byte[] oldValue, byte[] newValue) throws UnsupportedEncodingException {
        this.addChangedValues(attributeName, Utils.encodeBinary(oldValue), Utils.encodeBinary(newValue));
    }

    public void addObjectAttribute(String objectAttribName, byte[] objectAttribValue) throws UnsupportedEncodingException {
        this.addObjectAttribute(objectAttribName, Utils.encodeBinary(objectAttribValue));
    }

    public void addCustomAttribute(String customAttribName, byte[] customAttribValue) throws UnsupportedEncodingException {
        this.addCustomAttribute(customAttribName, Utils.encodeBinary(customAttribValue));
    }

    public void setMessage(String message) {
        this.addCustomAttribute("message", message);
    }

    public void log() throws AuditLogWriteException {
        if (Utils.isCloudScenario()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Will send audit log message to Audit Log Service server node");
            }
            try {
                this.validateMessage();
            }
            catch (ValidationError validationError) {
                throw new AuditLogWriteException("Audit log message cannot be validated.", this.messageObject.getErrors());
            }
            this.sendMessageToAuditlogServer();
        } else {
            Logger logger = LoggerFactory.getLogger((String)this.getCategory());
            logger.info(this.toString());
        }
    }

    private void validateMessage() throws ValidationError {
        if (this.messageVerb != null) {
            this.messageVerb.validate();
        }
        if (this.messageObject != null) {
            this.messageObject.validate();
        }
        if (this.messageCustom != null) {
            this.messageCustom.validate();
        }
    }

    public void log(String subcategory) throws AuditLogWriteException {
        this.addSubCategory(subcategory);
        this.log();
    }

    public void log(Class<?> loggedByClass) throws AuditLogWriteException {
        this.loggedByClassName = loggedByClass.getCanonicalName();
        this.log();
    }

    public void log(String subcategory, Class<?> loggedByClass) throws AuditLogWriteException {
        this.loggedByClassName = loggedByClass.getCanonicalName();
        this.log(subcategory);
    }

    protected String getVerbAsString() {
        return this.messageVerb == null ? null : this.messageVerb.toString();
    }

    protected String getObjectAsString() {
        return this.messageObject == null ? null : this.messageObject.toString();
    }

    protected String getCustomAsString() {
        return this.messageCustom == null ? null : this.messageCustom.toString();
    }

    protected void sendMessageToAuditlogServer() throws AuditLogWriteException {
        this.getCommunicationUtils().sendMessageToAuditlogServer(this);
    }

    private CommunicationUtils getCommunicationUtils() {
        if (this.communicationUtils == null) {
            this.communicationUtils = new CommunicationUtils();
        }
        return this.communicationUtils;
    }

    public void setCommunicationUtils(CommunicationUtils communicationUtils) {
        this.communicationUtils = communicationUtils;
    }

    protected String ensambleClientSideMetaDataFields() {
        this.messageId = FieldsProviderUtility.getMessageId();
        String clientSideMetadataFields = String.format("clientTimestamp=\"%s\", messageId=\"%s\", category=\"%s\", loggedByClass=\"%s\", correlation_id=\"%s\", ip_address=\"%s\", username=\"%s\", tenantId=\"%s\"", FieldsProviderUtility.getTime(), this.messageId, this.getCategory(), this.loggedByClassName, FieldsProviderUtility.getCorrelationId(), FieldsProviderUtility.getIPAddress(), FieldsProviderUtility.getCurrentUser(), FieldsProviderUtility.getTenantId());
        return clientSideMetadataFields;
    }

    protected Map<String, String> getHeadersForOnbehalfOf() {
        return null;
    }

    protected String ensambleOnbehalfOfMessage() {
        return null;
    }

    public String getCategory() {
        return this.category;
    }

    public void addSubCategory(String subCategory) {
        this.category = String.valueOf(this.category) + "." + Utils.encodeString(subCategory);
    }

    public void dataModified(String objectId, String objectName, String attributName, String oldValue, String newValue) {
        this.setAction(DataModificationAuditMessage.BasicActions.UPDATE);
        this.setObjectId(objectId);
        this.setObjectName(objectName);
        this.addModifiedValues(attributName, oldValue, newValue);
    }

    public void dataModified(String objectId, String objectName, String attributName, byte[] oldValue, byte[] newValue) throws UnsupportedEncodingException {
        this.dataModified(objectId, objectName, attributName, Utils.encodeBinary(oldValue), Utils.encodeBinary(newValue));
    }

    public void addModifiedValues(String attributeName, String oldValue, String newValue) {
        if (this.messageObject == null) {
            this.messageObject = new MessageObject();
        }
        this.messageObject.addObjectAttributeChange(Utils.encodeString(attributeName), Utils.encodeString(oldValue), Utils.encodeString(newValue));
    }

    public void addModifiedValues(String attributeName, byte[] oldValue, byte[] newValue) throws UnsupportedEncodingException {
        this.addModifiedValues(attributeName, Utils.encodeBinary(oldValue), Utils.encodeBinary(newValue));
    }

    public void dataCreated(String objectId) {
        this.setAction(DataModificationAuditMessage.BasicActions.CREATE);
        this.setObjectId(objectId);
    }

    public void dataDeleted(String objectId) {
        this.setAction(DataModificationAuditMessage.BasicActions.DELETE);
        this.setObjectId(objectId);
    }

    public void setDataSubject(AuditedDataSubject dataSubject) {
        if (this.messageObject == null) {
            this.messageObject = new MessageObject();
        }
        this.messageObject.addDataSubject(dataSubject);
    }

    public void setObject(AuditedObject object) {
        if (this.messageObject == null) {
            this.messageObject = new MessageObject();
        }
        this.messageObject.addAuditedObject(object);
    }
}

