/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.service.auditlog.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditlogDestinationInfo {
    protected static final String AUDITLOG_DESTINATION_FILE_LOCATION = "config_master/service.destinations/destinations/auditlogdestination";
    private String name;
    private String type;
    private String url;
    private String authentication;
    private String systemProxy;
    private String trustAll;
    private Logger logger = LoggerFactory.getLogger(AuditlogDestinationInfo.class);

    public AuditlogDestinationInfo() throws IOException {
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(AUDITLOG_DESTINATION_FILE_LOCATION);
            Properties auditlogDest = new Properties();
            auditlogDest.load(inStream);
            this.initializeValues(auditlogDest);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    this.logger.trace("Unable to close file input stream for config_master/service.destinations/destinations/auditlogdestination", (Throwable)e);
                }
            }
        }
    }

    private void initializeValues(Properties auditlogDest) {
        this.name = auditlogDest.getProperty("Name");
        this.type = auditlogDest.getProperty("Type");
        this.url = auditlogDest.getProperty("URL");
        this.authentication = auditlogDest.getProperty("Authentication");
        this.systemProxy = auditlogDest.getProperty("SystemProxy");
        this.trustAll = auditlogDest.getProperty("TrustAll");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public String getSystemProxy() {
        return this.systemProxy;
    }

    public String getSystemProxyHost() {
        int colonindex;
        if (this.systemProxy != null && (colonindex = this.systemProxy.indexOf(":")) > 0) {
            String proxyHost = this.systemProxy.substring(0, colonindex);
            return proxyHost;
        }
        return null;
    }

    public int getSystemProxyPort() {
        int colonindex;
        if (this.systemProxy != null && (colonindex = this.systemProxy.indexOf(":")) > 0) {
            int proxyPort = Integer.parseInt(this.systemProxy.substring(colonindex + 1));
            return proxyPort;
        }
        return -1;
    }

    public String getTrustAll() {
        return this.trustAll;
    }

    public void setTrustAll(String trustAll) {
        this.trustAll = trustAll;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

