/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.service.auditlog.impl;

import com.sap.cloud.auditlog.exception.AuditLogWriteException;
import com.sap.core.service.auditlog.impl.AuditLogMessageImpl;
import com.sap.core.service.auditlog.impl.AuditlogDestinationInfo;
import com.sap.core.service.auditlog.impl.RecoveryMessageScheduller;
import com.sap.core.service.auditlog.impl.S2SClient;
import com.sap.core.service.auditlog.impl.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationUtils {
    private static final String UTF_8 = "UTF-8";
    private static Logger logger = LoggerFactory.getLogger(CommunicationUtils.class);
    private static final String AUDIT_LOG_SERVICE_URL = "/api/v2/log";
    private static final String HEADER_CATEGORY = "category";
    private static final String BODY_CLIENTSIDE_METADATA = "clientside_metadata";
    private static final String BODY_ACTION = "verb";
    private static final String BODY_OBJECT = "object";
    private static final String BODY_CUSTOM = "custom";
    private static final String BODY_ONBEHALFOF = "onBehalfOf";
    private static final int MAX_RETRY_COUNT_ON_HTTP_ERROR_RESPONSE = 3;
    private static final int MAX_RETRY_COUNT_ON_EXCEPTION = 4;
    private static final long TIMEOUT_THRESHOLD = 20000L;

    public void sendMessageToAuditlogServer(AuditLogMessageImpl message) throws AuditLogWriteException {
        boolean clientSideError;
        AuditLogWriteException exception;
        block17: {
            S2SClient httpClient = null;
            exception = null;
            clientSideError = true;
            try {
                try {
                    HttpPost request = this.prepareRequest(message);
                    httpClient = this.getHttpClient(message);
                    HttpResponse response = this.sendAndRetryOnHttpErrorCodes(request, httpClient, message);
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 200) {
                        clientSideError = false;
                        this.consumeResponse(response);
                    } else {
                        if (statusCode == 403 || statusCode >= 500 && statusCode < 600) {
                            clientSideError = false;
                        }
                        this.consumeErrorResponseAndThrowException(response);
                    }
                }
                catch (AuditLogWriteException e) {
                    exception = e;
                    if (httpClient != null) {
                        httpClient.shutdown();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Connection Manager of Http client " + httpClient + " was closed.");
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (httpClient != null) {
                    httpClient.shutdown();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Connection Manager of Http client " + httpClient + " was closed.");
                    }
                }
                throw throwable;
            }
            if (httpClient != null) {
                httpClient.shutdown();
                if (logger.isDebugEnabled()) {
                    logger.debug("Connection Manager of Http client " + httpClient + " was closed.");
                }
            }
        }
        if (!clientSideError) {
            this.reportSuccess();
        }
        if (exception != null) {
            if (clientSideError) {
                String incidentErrorMessage = this.getDetailedErrorMessageForIncidentNotification(exception);
                this.reportError(incidentErrorMessage);
            }
            throw exception;
        }
    }

    protected HttpResponse sendAndRetryOnHttpErrorCodes(HttpPost request, S2SClient httpClient, AuditLogMessageImpl message) throws AuditLogWriteException {
        HttpResponse lastResponse = null;
        int i = 0;
        while (i < 3) {
            lastResponse = this.sendAndRetryOnException(request, httpClient);
            int responseStatusCode = lastResponse.getStatusLine().getStatusCode();
            if (!this.isStatusApplicableForRerey(responseStatusCode)) break;
            logger.error("Received response with HTTP status code: " + responseStatusCode + ". Request will be retried " + (3 - i - 1) + " times. Message ID is: " + message.messageId);
            this.consumeResponse(lastResponse);
            this.waitBeforeRetry(2000L);
            ++i;
        }
        return lastResponse;
    }

    protected HttpPost prepareRequest(AuditLogMessageImpl message) throws AuditLogWriteException {
        HttpPost request = new HttpPost(AUDIT_LOG_SERVICE_URL);
        request.addHeader(HEADER_CATEGORY, message.getCategory());
        Map<String, String> headersForOnbehalfOf = message.getHeadersForOnbehalfOf();
        if (headersForOnbehalfOf != null && headersForOnbehalfOf.size() > 0) {
            for (String headerName : headersForOnbehalfOf.keySet()) {
                request.setHeader(headerName, headersForOnbehalfOf.get(headerName));
            }
        }
        List<NameValuePair> requestBodyPairs = this.prepareMessageBodyToSend(message);
        this.setRequestBody(request, requestBodyPairs);
        return request;
    }

    protected List<NameValuePair> prepareMessageBodyToSend(AuditLogMessageImpl message) {
        ArrayList<NameValuePair> requestBodyPairs = new ArrayList<NameValuePair>(1);
        requestBodyPairs.add((NameValuePair)new BasicNameValuePair(BODY_CLIENTSIDE_METADATA, message.ensambleClientSideMetaDataFields()));
        this.addMessagePartIfNotNull(BODY_ACTION, message.getVerbAsString(), requestBodyPairs);
        this.addMessagePartIfNotNull(BODY_OBJECT, message.getObjectAsString(), requestBodyPairs);
        this.addMessagePartIfNotNull(BODY_CUSTOM, message.getCustomAsString(), requestBodyPairs);
        String onbehalfOfMessage = message.ensambleOnbehalfOfMessage();
        this.addMessagePartIfNotNull(BODY_ONBEHALFOF, onbehalfOfMessage, requestBodyPairs);
        return requestBodyPairs;
    }

    protected S2SClient getHttpClient(AuditLogMessageImpl message) throws AuditLogWriteException {
        AuditlogDestinationInfo auditlogDestinationInfo = null;
        try {
            auditlogDestinationInfo = Utils.getAuditlogDestinationInfo();
        }
        catch (IOException iOException) {
            logger.error("Unable to get auditlog service destination info from static destination, expected in the file config_master/service.destinations/destinations/auditlogdestination");
            throw new AuditLogWriteException("Unable to get auditlog service destination info");
        }
        try {
            S2SClient client = new S2SClient(auditlogDestinationInfo.getUrl(), auditlogDestinationInfo.getSystemProxyHost(), auditlogDestinationInfo.getSystemProxyPort());
            if (logger.isDebugEnabled()) {
                logger.debug("S2S client have been initialized for auditlog message " + message.messageId);
            }
            return client;
        }
        catch (Exception e) {
            logger.error("Unable to create S2S client for audit log message." + message.messageId + " Caused by: " + e.toString());
            throw new AuditLogWriteException("Unable to get Http client", (Throwable)e);
        }
    }

    protected boolean waitBeforeRetry(long waitTime) {
        if (waitTime != 0L) {
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException interrupted) {
                logger.error("Retry of the auditlog message was interupted.", (Throwable)interrupted);
                return false;
            }
        }
        return true;
    }

    protected void reportSuccess() {
        RecoveryMessageScheduller.getInstance().stopShceduledRecoveryThreadIfAvailable();
        try {
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("com.sap.cloud.auditlog:name=AuditLogClientStatus,type=AuditLogClientStatus");
            platformMBeanServer.invoke(objectName, "success", null, null);
        }
        catch (VirtualMachineError vme) {
            throw vme;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            logger.error("Unable to report ok status", t);
        }
    }

    private boolean isStatusApplicableForRerey(int responseStatusCode) {
        return responseStatusCode == 404 || responseStatusCode == 503;
    }

    private HttpResponse sendAndRetryOnException(HttpPost request, S2SClient httpClient) throws AuditLogWriteException {
        HttpResponse response = null;
        Exception exception = null;
        int i = 0;
        while (i < 4) {
            long currentRequestStartTimestamp = System.currentTimeMillis();
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Requesting Auditlog Service.");
                }
                response = httpClient.send((HttpRequestBase)request);
                exception = null;
                if (!logger.isDebugEnabled()) break;
                long requestFinishedTimestamp = System.currentTimeMillis();
                logger.debug("Response from the auditlog service took [" + (requestFinishedTimestamp - currentRequestStartTimestamp) + "] milliseconds.");
                break;
            }
            catch (Exception e) {
                exception = e;
                if (!this.processRetriableException(currentRequestStartTimestamp, i, e)) {
                    // empty if block
                }
                ++i;
            }
        }
        if (exception != null) {
            throw new AuditLogWriteException("Unable to send the auditlog message to the auditlog server.", exception);
        }
        return response;
    }

    private void addMessagePartIfNotNull(String messagePartName, Object messagePartValue, List<NameValuePair> requestBodyPairs) {
        if (messagePartValue != null) {
            requestBodyPairs.add((NameValuePair)new BasicNameValuePair(messagePartName, messagePartValue.toString()));
        }
    }

    private void consumeResponse(HttpResponse response) {
        try {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            logger.warn("Unable to read body of the response from the auditlog service. The return code is 200 OK.", (Throwable)e);
        }
    }

    private void setRequestBody(HttpPost request, List<NameValuePair> requestBodyPairs) throws AuditLogWriteException {
        try {
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(requestBodyPairs, UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            Utils.logErrorAndThrowAuditlogWriteException("Unable to set the auditlog message into the request for the auditlog server.", "Audit Log message will not be sent to Audit Log Service.", e);
        }
    }

    private void consumeErrorResponseAndThrowException(HttpResponse response) throws AuditLogWriteException {
        StringBuilder responseMessage = new StringBuilder();
        BufferedReader br = null;
        try {
            try {
                String line;
                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), UTF_8));
                while ((line = br.readLine()) != null) {
                    responseMessage.append(line);
                }
            }
            catch (Exception exception) {
                logger.error("Unable to read error message from the server response. Audit Log message was sent to Audit Log Service, but error response " + response.getStatusLine().getStatusCode() + " occured.");
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        logger.warn("Unable to close response body stream from the auditlog service.", (Throwable)e);
                    }
                }
                Utils.logErrorAndThrowAuditlogWriteException("Recieved HTTP error code " + response.getStatusLine().getStatusCode() + " in response.", "Audit log mihgt not be written to the destination backend. Serverside response:\n" + responseMessage, null);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.warn("Unable to close response body stream from the auditlog service.", (Throwable)e);
                }
            }
            Utils.logErrorAndThrowAuditlogWriteException("Recieved HTTP error code " + response.getStatusLine().getStatusCode() + " in response.", "Audit log mihgt not be written to the destination backend. Serverside response:\n" + responseMessage, null);
        }
    }

    private void reportError(String nagiosError) {
        RecoveryMessageScheduller.getInstance().stopShceduledRecoveryThreadIfAvailable();
        RecoveryMessageScheduller.getInstance().scheduleRecoveryAuditlogMessage();
        try {
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("com.sap.cloud.auditlog:name=AuditLogClientStatus,type=AuditLogClientStatus");
            Object[] params = new Object[]{nagiosError};
            String[] signature = new String[]{String.class.getName()};
            platformMBeanServer.invoke(objectName, "failure", params, signature);
        }
        catch (VirtualMachineError vme) {
            throw vme;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            logger.error("Unable to report error status", t);
        }
    }

    private String getDetailedErrorMessageForIncidentNotification(AuditLogWriteException exception) {
        String nagiosError = "Unable to perform audit log. Exception: " + (Object)((Object)exception) + " Caused by: " + exception.getCause();
        return nagiosError;
    }

    private long calculateWaitTime(long delay, int i) {
        if (i > 4) {
            return 0L;
        }
        if (delay > 20000L || delay < 0L) {
            return 0L;
        }
        if (delay == 0L) {
            logger.warn("Too fast error response. Check the relevance of retrying the request.");
            return 2000L;
        }
        return Math.min(500L, 30000L / delay) + (long)(i * 1000);
    }

    private boolean processRetriableException(long currentRequestStartTimestamp, int i, Exception e) {
        long delay = System.currentTimeMillis() - currentRequestStartTimestamp;
        long waitTime = this.calculateWaitTime(delay, i);
        int actualAttempt = i + 1;
        if (i == 3) {
            logger.error("Unable to log the auditlog message to the auditlog server due to: [" + e.getMessage() + "]. Request duration: [" + delay + "] milliseconds. Used last attempt: " + actualAttempt + " from 4 to resend in [" + waitTime + "] miliseconds ...");
        } else {
            logger.warn("Unable to send the auditlog message to the auditlog server due to: [" + e.getMessage() + "]. Request duration: [" + delay + "] milliseconds. Using attempt " + actualAttempt + " from 4 to resend in [" + waitTime + "] miliseconds ...");
        }
        return this.waitBeforeRetry(waitTime);
    }
}

