/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.service.auditlog.impl;

import com.sap.core.tenant.api.Tenant;
import com.sap.core.tenant.common.TenantData;
import com.sap.security.auth.service.UserSession;
import com.sap.security.um.user.User;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldsProviderUtility {
    public static final String ATTRIBUTE_CLIENT_PROPERTIES = "com.sap.core.communication.server.clientProperties";
    public static final String PERMISSON_SET_USER = "setUser";
    public static final String PROPERTY_PERMISSIONS = "permissions";
    public static final String PROPERTY_USER = "user";
    private static Logger logger = LoggerFactory.getLogger(FieldsProviderUtility.class);
    private static final String messageIdPrefix;
    private static long auditlogMessageCounter;

    static {
        auditlogMessageCounter = 0L;
        String myTimestamp = Long.toHexString(System.currentTimeMillis());
        new File(System.getProperty("user.dir")).getName();
        String myHostName = "host";
        try {
            myHostName = FieldsProviderUtility.getHostName(InetAddress.getLocalHost().getHostName());
        }
        catch (Exception e) {
            logger.warn("The MessageID initialization failed and will not contain propper value.", (Throwable)e);
            myHostName = "noHost";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(myHostName);
        sb.append("-");
        sb.append(myTimestamp);
        sb.append("-");
        messageIdPrefix = sb.toString();
    }

    static String getHostName(String localHostName) throws UnknownHostException {
        int firstIndexOfDot = localHostName.indexOf(".");
        String myHostName = firstIndexOfDot != -1 ? localHostName.substring(0, firstIndexOfDot) : localHostName;
        logger.info("The hostname is " + myHostName);
        if (myHostName.startsWith("vsa") || myHostName.startsWith("VSA")) {
            myHostName = Long.toHexString(new Long(myHostName.substring(3)));
            logger.debug("The hostname as hexa is: " + myHostName);
        }
        return myHostName;
    }

    public static String getTime() {
        Date today = new Date(System.currentTimeMillis());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH.mm.ss.SSSZ");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format.format(today);
    }

    public static String getCorrelationId() {
        return "";
    }

    public static String getIPAddress() {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            logger.warn("Local host addres could not be determined. Auditlog message will have blank IP.");
            return "";
        }
        return addr.getHostAddress();
    }

    public static String getCurrentUser() {
        String username = FieldsProviderUtility.getAuthenticatedUsername();
        if (username != null) {
            return username;
        }
        username = FieldsProviderUtility.getServicePropagatedUsername();
        if (username != null) {
            return username;
        }
        return FieldsProviderUtility.getInjectedIntoThreadUsername();
    }

    private static String getAuthenticatedUsername() {
        String user = UserSession.getInstance().getAuthenticatedPrincipalName();
        if (user == null) {
            return null;
        }
        String authProvider = UserSession.getInstance().getPrincipalUssuerName();
        if (authProvider != null && !authProvider.isEmpty()) {
            return String.valueOf(user) + "@" + authProvider;
        }
        return user;
    }

    private static String getServicePropagatedUsername() {
        return FieldsProviderUtility.getS2SUser((Properties)UserSession.getInstance().getAttribute(ATTRIBUTE_CLIENT_PROPERTIES));
    }

    private static String getInjectedIntoThreadUsername() {
        User currentUser = UserSession.getInstance().getCurrentUser();
        if (currentUser == null) {
            return null;
        }
        return currentUser.getName();
    }

    static String getS2SUser(Properties certProperties) {
        if (certProperties == null) {
            return null;
        }
        if (!certProperties.containsKey(PROPERTY_USER)) {
            return null;
        }
        if (FieldsProviderUtility.hasPermission(certProperties, PERMISSON_SET_USER)) {
            return certProperties.getProperty(PROPERTY_USER);
        }
        logger.error("Service does not have 'setUser' permission in order to propagate user. Properties: {}", (Object)certProperties);
        return null;
    }

    private static boolean hasPermission(Properties certProperties, String permission) {
        return certProperties != null && certProperties.containsKey(PROPERTY_PERMISSIONS) && certProperties.getProperty(PROPERTY_PERMISSIONS).contains(permission);
    }

    public static String getTenantId() {
        if (Boolean.getBoolean("com.sap.cloud.auditlog.skipTenantAPI")) {
            return "";
        }
        if (Boolean.getBoolean("com.sap.cloud.domaindb")) {
            return "";
        }
        TenantData tenantData = Tenant.getData();
        if (tenantData != null) {
            return tenantData.getId();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessageId() {
        long counterValue;
        String string = messageIdPrefix;
        synchronized (string) {
            counterValue = ++auditlogMessageCounter;
        }
        return String.valueOf(messageIdPrefix) + Long.toHexString(counterValue);
    }
}

