/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.service.auditlog.impl;

import com.sap.core.service.auditlog.impl.MessageLoggerJob;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryMessageScheduller {
    private static Logger logger = LoggerFactory.getLogger(RecoveryMessageScheduller.class);
    private static RecoveryMessageScheduller instance = null;
    private final ScheduledExecutorService recoveryScheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> handler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static RecoveryMessageScheduller getInstance() {
        if (instance != null) return instance;
        Class<RecoveryMessageScheduller> clazz = RecoveryMessageScheduller.class;
        synchronized (RecoveryMessageScheduller.class) {
            if (instance != null) return instance;
            instance = new RecoveryMessageScheduller();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void scheduleRecoveryAuditlogMessage() {
        MessageLoggerJob messageLogger = new MessageLoggerJob();
        long delay = 30L;
        TimeUnit unit = TimeUnit.MINUTES;
        this.handler = this.recoveryScheduler.schedule(messageLogger, delay, unit);
    }

    public void stopShceduledRecoveryThreadIfAvailable() {
        ScheduledFuture<?> myHandler = this.handler;
        if (myHandler != null) {
            boolean isAlreadyCanceledExecution = !myHandler.cancel(false);
            logger.info("Canceling execution of the recovery Message Scheduller. Already canceled:" + isAlreadyCanceledExecution);
            this.handler = null;
        }
    }
}

