/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.service.auditlog.impl;

import com.sap.core.service.auditlog.impl.CommunicationTrustManager;
import com.sap.core.service.auditlog.impl.OSGiLocalKeystoreServiceProvider;
import com.sap.jpaas.service.securestore.local.keystore.LocalKeystoreService;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S2SClient {
    private static final String VM_CERT_ALIAS = "vm_cert";
    private static Logger log = LoggerFactory.getLogger(S2SClient.class);
    private static KeyStore clientKeystore = null;
    private static char[] passwd = new char[]{'s', 'u', 'p', 'e', 'r', 's', 'e', 'c', 'r', 'e', 't'};
    private String serviceUri = null;
    private HttpClient client;
    private static final Integer CONNECTION_TIMEOUT_VALUE = 30000;
    private static final Integer CONNECTION_SOCKET_TIMEOUT_VALUE = 20000;
    private static boolean isOSGi = System.getProperty("osgi.install.area") != null;

    public S2SClient(HttpClient client) {
        this.client = client;
    }

    public S2SClient(String serviceUri, String proxyHost, int proxyport) throws URISyntaxException, GeneralSecurityException, IOException {
        this.serviceUri = serviceUri;
        this.client = S2SClient.createHttpClient(serviceUri, proxyHost, proxyport);
    }

    private static HttpClient createHttpClient(String serviceUri, String proxyHost, int proxyport) throws GeneralSecurityException, IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        SSLContext sslCtx = S2SClient.createAndInitializeSslContext();
        SSLSocketFactory socketFactory = new SSLSocketFactory(sslCtx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        Scheme scheme = S2SClient.createSchemeFromSocketFactory(serviceUri, socketFactory);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpParams params = client.getParams();
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)CONNECTION_SOCKET_TIMEOUT_VALUE);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)CONNECTION_TIMEOUT_VALUE);
        if (proxyHost != null && proxyport > 0) {
            HttpHost proxy = new HttpHost(proxyHost, proxyport);
            params.setParameter("http.route.default-proxy", (Object)proxy);
        }
        client.getConnectionManager().getSchemeRegistry().register(scheme);
        return client;
    }

    private static SSLContext createAndInitializeSslContext() throws GeneralSecurityException, IOException {
        SSLContext ctx;
        block4: {
            if (clientKeystore == null) {
                KeyStore.Entry vmcertEntry = S2SClient.getVmCertificate();
                clientKeystore = S2SClient.createKeystoreWithClientCertificate(vmcertEntry, passwd);
            }
            ctx = null;
            try {
                ctx = SSLContext.getInstance("TLS");
            }
            catch (NoSuchAlgorithmException nsae) {
                if (!log.isInfoEnabled()) break block4;
                log.info("Error during initialization of SSLContext:" + nsae.getMessage());
            }
        }
        if (ctx == null) {
            throw new IllegalStateException("Supported versions are : TLSv1.2, TLSv1.1, TLSv1");
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(clientKeystore, passwd);
        CommunicationTrustManager easyTrustManager = new CommunicationTrustManager();
        ctx.init(keyManagerFactory.getKeyManagers(), new TrustManager[]{easyTrustManager}, null);
        return ctx;
    }

    private static KeyStore createKeystoreWithClientCertificate(KeyStore.Entry vmcertEntry, char[] passwd) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore newKeystore = KeyStore.getInstance("JKS");
        newKeystore.load(null, passwd);
        newKeystore.setEntry("clientCert", vmcertEntry, new KeyStore.PasswordProtection(passwd));
        return newKeystore;
    }

    private static KeyStore.Entry getVmCertificate() throws GeneralSecurityException, IOException {
        LocalKeystoreService ksService = null;
        if (isOSGi) {
            ksService = OSGiLocalKeystoreServiceProvider.getLocalKeystoreService();
        } else {
            ServiceLoader<LocalKeystoreService> keystoreServiceLoader = ServiceLoader.load(LocalKeystoreService.class);
            Iterator<LocalKeystoreService> iterator = keystoreServiceLoader.iterator();
            if (iterator.hasNext()) {
                ksService = iterator.next();
            } else {
                log.error("Could not obtain secure store service.Cannot load CA public key.");
                throw new IllegalStateException("Secure store service is not available.Cannot load CA public key.");
            }
        }
        return ksService.getEntry(VM_CERT_ALIAS);
    }

    public HttpResponse send(HttpRequestBase request) throws IOException, URISyntaxException {
        URI uriOriginal = request.getURI();
        if (log.isDebugEnabled()) {
            log.debug("uriOriginal.getRawPath()= " + uriOriginal.getRawPath() + "\n");
            log.debug("serviceUri= " + this.serviceUri + "\n");
        }
        URI uriCurrent = new URI(String.valueOf(this.serviceUri) + uriOriginal.getRawPath());
        request.setURI(uriCurrent);
        HttpResponse response = this.client.execute((HttpUriRequest)request);
        request.setURI(uriOriginal);
        return response;
    }

    public void shutdown() {
        this.client.getConnectionManager().shutdown();
    }

    private static Scheme createSchemeFromSocketFactory(String destinationUrl, SSLSocketFactory socketFactory) throws URISyntaxException {
        URI uri = new URI(destinationUrl);
        int port = uri.getPort();
        if (port == -1) {
            port = 443;
        }
        Scheme scheme = new Scheme(uri.getScheme(), port, (SchemeSocketFactory)socketFactory);
        return scheme;
    }
}

