/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.service.auditlog.impl;

import com.sap.cloud.auditlog.exception.AuditLogWriteException;
import com.sap.core.jpaas.security.utils.Base64;
import com.sap.core.service.auditlog.impl.AuditlogDestinationInfo;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static Logger logger = LoggerFactory.getLogger(Utils.class);
    static final String NULL_VALUE = "%null";
    static final String VOID_VALUE = "%void";
    private static String[][] encodingSymbols = new String[][]{{"%", "%25"}, {"\"", "%22"}, {"\n", "%10"}};
    protected static Boolean isCloudScenario = null;
    private static AuditlogDestinationInfo auditlogDestinationInfo = null;

    public static String encodeString(String stringToEncode) {
        if (stringToEncode == null) {
            return NULL_VALUE;
        }
        String out = stringToEncode;
        int i = 0;
        while (i < encodingSymbols.length) {
            String[] currentPair = encodingSymbols[i];
            out = out.replaceAll(currentPair[0], currentPair[1]);
            ++i;
        }
        return out;
    }

    public static String decodeString(String stringToDecode) {
        if (stringToDecode == null) {
            throw new IllegalArgumentException("Null cannot be decoded to a value.");
        }
        if (stringToDecode.equals(VOID_VALUE)) {
            throw new IllegalArgumentException("Void value [ + VOID_VALUE + ] cannot be decoded to a valid string or null.");
        }
        if (stringToDecode.equals(NULL_VALUE)) {
            return null;
        }
        String out = stringToDecode;
        int i = encodingSymbols.length - 1;
        while (i >= 0) {
            String[] currentPair = encodingSymbols[i];
            out = out.replaceAll(currentPair[1], currentPair[0]);
            --i;
        }
        return out;
    }

    public static String encodeBinary(byte[] value) throws UnsupportedEncodingException {
        return Base64.encode((byte[])value);
    }

    public static byte[] decodeBinary(String value) throws UnsupportedEncodingException {
        return Base64.decode((String)value);
    }

    public static boolean writeMessagePart(StringBuilder builder, boolean addPairSeparator, Object messagePart, String messagePartName) {
        if (messagePart != null) {
            if (addPairSeparator) {
                builder.append(",");
            }
            builder.append(messagePartName);
            builder.append("=");
            builder.append(messagePart.toString());
            addPairSeparator = true;
        }
        return addPairSeparator;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isCloudScenario() {
        block16: {
            block17: {
                if (Utils.isCloudScenario != null) {
                    return Utils.isCloudScenario;
                }
                stream = null;
                spaceProperties = new Properties();
                stream = new FileInputStream("space.properties");
                spaceProperties.load(stream);
                landscape = spaceProperties.getProperty("landscape");
                if (landscape == null || landscape.length() <= 0) break block16;
                Utils.logger.info("Determined landscape name:[" + landscape + "].");
                Utils.isCloudScenario = true;
                if (stream == null) break block17;
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Utils.logger.trace("Unable to close file input stream.", (Throwable)e);
                }
            }
            return true;
        }
        try {
            try {
                Utils.logger.error("WARNING: Unable to determine landscape name because landscape name was not specified. Possible reason - Local dev scenario.");
            }
            catch (IOException v0) {
                Utils.logger.error("WARNING: Unable to determine landscape name. Possible reason - Local dev scenario.");
                if (stream == null) ** GOTO lbl49
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Utils.logger.trace("Unable to close file input stream.", (Throwable)e);
                }
            }
        }
        catch (Throwable var3_7) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Utils.logger.trace("Unable to close file input stream.", (Throwable)e);
                }
            }
            throw var3_7;
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                Utils.logger.trace("Unable to close file input stream.", (Throwable)e);
            }
        }
lbl49:
        // 7 sources

        Utils.isCloudScenario = false;
        return false;
    }

    protected static AuditlogDestinationInfo getAuditlogDestinationInfo() throws IOException {
        if (auditlogDestinationInfo == null) {
            auditlogDestinationInfo = new AuditlogDestinationInfo();
        }
        return auditlogDestinationInfo;
    }

    protected static void logErrorAndThrowAuditlogWriteException(String customMessage, String consequence) throws AuditLogWriteException {
        Utils.logErrorAndThrowAuditlogWriteException(customMessage, consequence, null);
    }

    protected static void logErrorAndThrowAuditlogWriteException(String customMessage, String consequence, Exception causedBy) throws AuditLogWriteException {
        logger.error(String.valueOf(customMessage) + consequence);
        if (logger.isDebugEnabled() && causedBy != null) {
            logger.debug("Exception trace ", (Throwable)causedBy);
        }
        throw new AuditLogWriteException(customMessage, (Throwable)causedBy);
    }
}

