/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.service.auditlog.message;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.auditlog.AuditedDataSubject;
import com.sap.cloud.auditlog.AuditedObject;
import com.sap.cloud.auditlog.exception.ValidationError;
import com.sap.core.service.auditlog.impl.AuditedDataSubjectImpl;
import com.sap.core.service.auditlog.impl.AuditedObjectImpl;
import java.util.HashMap;
import java.util.Map;

public class MessageObject {
    private static final String OLD_VALUE = "oldValue";
    private static final String NEW_VALUE = "newValue";
    private String objectName = null;
    private JsonObject attributes = null;
    private JsonObject auditedObject = null;
    private JsonObject auditedDataSubject = null;
    protected Map<String, String> errors = new HashMap<String, String>();

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectname() {
        return this.objectName;
    }

    public void addObjectAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new JsonObject();
        }
        this.attributes.addProperty(name, value);
    }

    public void addObjectAttributeChange(String attributeName, String oldValue, String newValue) {
        if (this.attributes == null) {
            this.attributes = new JsonObject();
        }
        JsonObject values = new JsonObject();
        values.addProperty(OLD_VALUE, oldValue);
        values.addProperty(NEW_VALUE, newValue);
        this.attributes.add(attributeName, (JsonElement)values);
    }

    public JsonObject getAttributes() {
        return this.attributes;
    }

    public String toString() {
        JsonObject jsonObj = new JsonObject();
        if (this.objectName != null) {
            jsonObj.addProperty("objectName", this.objectName);
        }
        if (this.attributes != null) {
            jsonObj.add("objectAttributs", (JsonElement)this.attributes);
        }
        if (this.auditedObject != null) {
            jsonObj.add("auditedObject", (JsonElement)this.auditedObject);
        }
        if (this.auditedDataSubject != null) {
            jsonObj.add("auditedDataSubject", (JsonElement)this.auditedDataSubject);
        }
        return jsonObj.toString();
    }

    public void addDataSubject(AuditedDataSubject auditedDataSubject) {
        this.auditedDataSubject = ((AuditedDataSubjectImpl)auditedDataSubject).toJSONObject();
    }

    public JsonObject getDataSubject() {
        return this.auditedDataSubject;
    }

    public void addAuditedObject(AuditedObject auditedObject) {
        this.auditedObject = ((AuditedObjectImpl)auditedObject).toJSONObject();
    }

    public JsonObject getAuditedObject() {
        return this.auditedObject;
    }

    public void validate() throws ValidationError {
        if (this.auditedObject != null) {
            if (this.auditedObject.getAsJsonPrimitive("type") == null) {
                this.errors.put("auditedObject.type", "'auditedObject.type' property cannot be null or empty");
            }
            if (this.auditedObject.get("id") == null) {
                this.errors.put("auditedObject.id", "'auditedObject.id' property cannot be null or empty. At least one identifier required");
            }
        }
        if (this.auditedDataSubject != null) {
            if (this.auditedDataSubject.getAsJsonPrimitive("type") == null) {
                this.errors.put("subject.type", "'auditedDataSubject.type' property cannot be null or empty");
            }
            if (this.auditedDataSubject.get("id") == null) {
                this.errors.put("subject.id", "'auditedDataSubject.id' property cannot be null or empty.  At least one identifier required");
            }
        }
        if (this.errors.size() > 0) {
            throw new ValidationError("The audit message contains some invalid properties. For more details use the getErrors() method");
        }
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }
}

