#!/bin/sh

validate()
{
    if [ -z "$1" ]; then
        echo "$2 was not provided!"
        exit 1
    fi
}

executeScript()
{
echo Executing step: "$2"
    value=$(eval "$1")
    if [ "$?" != "0" ]; then
    	echo SDK upgrade Error: Command "$1" output:"${value}"
    	echo Backup of your old SDK is located in "${backup}"
        exit 1
    fi
}

#Validate input parameters
currentVersionDirectory=$2
validate "${currentVersionDirectory}" "Current SDK directory"

updatedVersionDirectory=$3
validate "${updatedVersionDirectory}" "Upgraded SDK directory"

backupDirectory=$4
validate "${backupDirectory}" "Backup directory"

#Prepare directories to  be wiped out
currentVersionDirectory=$(echo ${currentVersionDirectory} | sed 's/^"//' | sed 's/"$//')

apiDir="${currentVersionDirectory}/api"
licenseDir="${currentVersionDirectory}/license"
repoDir="${currentVersionDirectory}/repository"
logDir="${currentVersionDirectory}/tools/log"
libDir="${currentVersionDirectory}/tools/lib"

#Wipeout files from current version location
executeScript "rm -rf ${apiDir}" "Removing old content from api folder..."
executeScript "rm -rf ${licenseDir}" "Removing old content from license folder..."
executeScript "rm -rf ${repoDir}" "Removing old content from repository folder..."
executeScript "rm -rf ${logDir}" "Removing old logs..."
executeScript "rm -rf ${libDir}" "Removing old tools..."


#Copy files from upgraded version location to current version location
executeScript "cp -r ${updatedVersionDirectory}/* ${currentVersionDirectory}" "Upgrading with new content..."

#Update execution permissions for scripts in current (now updated) directory
executeScript "find ${currentVersionDirectory}/ -name \"*.sh\" -exec chmod +x {} \;" "Fixing file permissions..."

#Wipe out Updated version location as no longer needed
executeScript "rm -rf ${updatedVersionDirectory}" "Removing temporary files..."

#Remove backup
executeScript "rm -rf ${backupDirectory}" "Removing backup files..."

echo SDK Upgrade is complete!
echo
#Script removes itself
rm "$0"
